/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.connector.ConnectorComponent;
import org.apache.camel.component.connector.DataType;
import org.apache.camel.component.connector.DefaultConnectorEndpoint;
import org.apache.camel.processor.Pipeline;

@ManagedResource(description="Managed Scheduled TimerConnector Endpoint")
public class SchedulerTimerConnectorEndpoint
extends DefaultConnectorEndpoint {
    private long period = 1000L;

    public SchedulerTimerConnectorEndpoint(String endpointUri, ConnectorComponent component, Endpoint endpoint, DataType inputDataType, DataType outputDataType) {
        super(endpointUri, component, endpoint, inputDataType, outputDataType);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        ArrayList<Object> children = new ArrayList<Object>(2);
        children.add(this.createProducer());
        children.add(processor);
        Processor pipeline = Pipeline.newInstance((CamelContext)this.getCamelContext(), children);
        String name = this.getComponent().getComponentName();
        String uri = "timer:" + name + "?period=" + this.period;
        Consumer consumer = this.getCamelContext().getEndpoint(uri).createConsumer(pipeline);
        this.configureConsumer(consumer);
        return consumer;
    }

    @ManagedAttribute(description="Delay in milli seconds between scheduling (executing)")
    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }
}

