/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.component.connector.ConnectorComponent;
import org.apache.camel.component.connector.ConnectorModel;
import org.apache.camel.component.connector.DefaultConnectorEndpoint;
import org.apache.camel.component.connector.SchedulerTimerConnectorEndpoint;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultConnectorComponent
extends DefaultComponent
implements ConnectorComponent,
VerifiableComponent {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CamelCatalog catalog = new DefaultCamelCatalog(false);
    private final String baseScheme;
    private final String componentName;
    private final String componentScheme;
    private final ConnectorModel model;
    private final Map<String, Object> options;
    private Processor beforeProducer;
    private Processor afterProducer;
    private Processor beforeConsumer;
    private Processor afterConsumer;

    protected DefaultConnectorComponent(String componentName, String className) {
        this(componentName, DefaultConnectorComponent.loadConnectorClass(className));
    }

    protected DefaultConnectorComponent(String componentName, Class<?> componentClass) {
        this.model = new ConnectorModel(componentName, componentClass);
        this.baseScheme = this.model.getBaseScheme();
        this.componentName = componentName;
        this.componentScheme = componentName + "-component";
        this.options = new HashMap<String, Object>();
        this.catalog.addComponent(componentName, componentClass.getName());
        if (!this.catalog.findComponentNames().contains(this.baseScheme)) {
            this.catalog.addComponent(this.baseScheme, this.model.getBaseJavaType());
        }
        if (!this.catalog.findComponentNames().contains(this.componentScheme)) {
            this.catalog.addComponent(this.componentScheme, this.model.getBaseJavaType(), this.catalog.componentJSonSchema(this.baseScheme));
        }
        this.registerExtension(this::getComponentVerifierExtension);
    }

    private static Class<?> loadConnectorClass(String className) {
        try {
            ClassLoader classLoader = DefaultConnectorComponent.class.getClassLoader();
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected <T> void doAddOption(Map<String, T> options, String name, T value) {
        this.log.trace("Adding option: {}={}", (Object)name, value);
        T val = options.put(name, value);
        if (val != null) {
            this.log.debug("Options {} overridden, old value was {}", (Object)name, val);
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DefaultConnectorEndpoint answer;
        int before = parameters.size();
        Map<String, Object> schedulerOptions = this.extractSchedulerOptions(parameters);
        int after = parameters.size();
        if (schedulerOptions != null && before != after) {
            URI u = new URI(uri);
            u = URISupport.createRemainingURI((URI)u, parameters);
            uri = u.toString();
        }
        Map<String, String> options = this.buildEndpointOptions(remaining, parameters);
        String delegateUri = this.createEndpointUri(this.componentScheme, options);
        Endpoint delegate = this.getCamelContext().getEndpoint(delegateUri);
        if (this.log.isInfoEnabled()) {
            this.log.info("Connector resolved: {} -> {}", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizeUri((String)delegateUri));
        }
        if ("timer".equals(this.model.getScheduler())) {
            SchedulerTimerConnectorEndpoint endpoint = new SchedulerTimerConnectorEndpoint(uri, this, delegate, this.model.getInputDataType(), this.model.getOutputDataType());
            this.setProperties((Object)endpoint, schedulerOptions);
            answer = endpoint;
        } else {
            answer = new DefaultConnectorEndpoint(uri, this, delegate, this.model.getInputDataType(), this.model.getOutputDataType());
        }
        parameters.clear();
        return answer;
    }

    @Override
    public String createEndpointUri(String scheme, Map<String, String> options) throws URISyntaxException {
        this.log.trace("Creating endpoint uri with scheme: {}", (Object)scheme);
        return this.catalog.asEndpointUri(scheme, options, false);
    }

    @Override
    public CamelCatalog getCamelCatalog() {
        return this.catalog;
    }

    @Override
    public String getCamelConnectorJSon() {
        return this.model.getConnectorJSon();
    }

    @Override
    public String getConnectorName() {
        return this.model.getConnectorName();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.options.clear();
        this.options.putAll(options);
    }

    @Override
    public void addOption(String name, Object value) {
        this.doAddOption(this.options, name, value);
    }

    @Override
    public void addOptions(Map<String, Object> options) {
        options.forEach((name, value) -> this.doAddOption((Map)this.options, (String)name, (Object)value));
    }

    public ComponentVerifier getVerifier() {
        return (scope, parameters) -> ((ComponentVerifierExtension)this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new)).verify(scope, parameters);
    }

    private ComponentVerifierExtension getComponentVerifierExtension() {
        try {
            Component component = this.createNewBaseComponent();
            Optional extension = component.getExtension(ComponentVerifierExtension.class);
            if (extension.isPresent()) {
                return (scope, map) -> {
                    Map<String, String> options;
                    try {
                        options = this.buildEndpointOptions(null, map);
                    }
                    catch (URISyntaxException | NoTypeConversionAvailableException e) {
                        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)scope).error(ResultErrorBuilder.withException((Exception)e).build()).build();
                    }
                    return ((ComponentVerifierExtension)extension.get()).verify(scope, options);
                };
            }
            return (scope, map) -> ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.UNSUPPORTED, (ComponentVerifierExtension.Scope)scope).error(ResultErrorBuilder.withCode((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED).detail("camel_connector_name", (Object)this.getConnectorName()).detail("camel_component_name", (Object)this.getComponentName()).build()).build();
        }
        catch (Exception e) {
            return (scope, map) -> ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)scope).error(ResultErrorBuilder.withException((Exception)e).build()).build();
        }
    }

    protected void doStart() throws Exception {
        if (this.model.getInputDataType() == null) {
            throw new IllegalArgumentException("Camel connector must have inputDataType defined in camel-connector.json file");
        }
        if (this.model.getOutputDataType() == null) {
            throw new IllegalArgumentException("Camel connector must have outputDataType defined in camel-connector.json file");
        }
        if (this.model.getBaseScheme() == null) {
            throw new IllegalArgumentException("Camel connector must have baseSchema defined in camel-connector.json file");
        }
        if (this.model.getBaseJavaType() == null) {
            throw new IllegalArgumentException("Camel connector must have baseJavaType defined in camel-connector.json file");
        }
        Component component = this.createNewBaseComponent();
        if (component != null) {
            this.getCamelContext().removeComponent(this.componentScheme);
            this.getCamelContext().addService((Object)component, true, true);
            this.getCamelContext().addComponent(this.componentScheme, component);
        }
        this.log.debug("Starting connector: {}", (Object)this.componentName);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.debug("Stopping connector: {}", (Object)this.componentName);
        super.doStop();
    }

    @Override
    public Processor getBeforeProducer() {
        return this.beforeProducer;
    }

    @Override
    public void setBeforeProducer(Processor beforeProducer) {
        this.beforeProducer = beforeProducer;
    }

    @Override
    public Processor getAfterProducer() {
        return this.afterProducer;
    }

    @Override
    public void setAfterProducer(Processor afterProducer) {
        this.afterProducer = afterProducer;
    }

    @Override
    public Processor getBeforeConsumer() {
        return this.beforeConsumer;
    }

    @Override
    public void setBeforeConsumer(Processor beforeConsumer) {
        this.beforeConsumer = beforeConsumer;
    }

    @Override
    public Processor getAfterConsumer() {
        return this.afterConsumer;
    }

    @Override
    public void setAfterConsumer(Processor afterConsumer) {
        this.afterConsumer = afterConsumer;
    }

    private Component createNewBaseComponent() throws Exception {
        Class<?> type;
        Constructor ctr;
        String baseClassName = this.model.getBaseJavaType();
        CamelContext context = this.getCamelContext();
        Component base = null;
        if (baseClassName != null && (ctr = DefaultConnectorComponent.getPublicDefaultConstructor(type = Class.forName(baseClassName))) != null) {
            base = (Component)ctr.newInstance(new Object[0]);
            base.setCamelContext(context);
            Map<String, String> defaultOptions = this.model.getDefaultComponentOptions();
            if (!defaultOptions.isEmpty()) {
                for (Map.Entry<String, String> entry : defaultOptions.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) continue;
                    value = this.getCamelContext().resolvePropertyPlaceholders(value);
                    this.log.debug("Using component option: {}={}", (Object)key, (Object)value);
                    IntrospectionSupport.setProperty((CamelContext)context, (Object)base, (String)key, (Object)value);
                }
            }
            if (this.options != null && !this.options.isEmpty()) {
                List<String> endpointOptions = this.model.getEndpointOptions();
                List<String> connectorOptions = this.model.getConnectorOptions();
                for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                    if (endpointOptions.contains(entry.getKey()) || connectorOptions.contains(entry.getKey())) continue;
                    this.log.debug("Using component option: {}={}", (Object)entry.getKey(), entry.getValue());
                    IntrospectionSupport.setProperty((CamelContext)context, (Object)base, (String)entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        return base;
    }

    private Map<String, Object> extractSchedulerOptions(Map<String, Object> parameters) {
        if (this.model.getScheduler() != null) {
            LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
            this.model.getDefaultEndpointOptions().forEach((key, value) -> {
                String schedulerKey = DefaultConnectorComponent.asSchedulerKey(key);
                if (schedulerKey != null) {
                    answer.put(schedulerKey, value);
                }
            });
            Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String schedulerKey = DefaultConnectorComponent.asSchedulerKey(entry.getKey());
                if (schedulerKey == null) continue;
                Object value2 = entry.getValue();
                answer.put(schedulerKey, value2);
                it.remove();
            }
            return answer;
        }
        return null;
    }

    private static String asSchedulerKey(String key) {
        if (key.startsWith("scheduler")) {
            String name = key.substring(9);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            return name;
        }
        return null;
    }

    private Map<String, String> buildEndpointOptions(String remaining, Map<String, Object> parameters) throws URISyntaxException, NoTypeConversionAvailableException {
        String targetUri;
        Map map;
        List<String> endpointOptions;
        Map<String, String> defaultOptions = this.model.getDefaultEndpointOptions();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (!defaultOptions.isEmpty()) {
            defaultOptions.forEach((key, value) -> {
                if (this.isValidConnectionOption((String)key, (String)value)) {
                    this.doAddOption((Map)options, (String)key, (Object)value);
                }
            });
        }
        if (ObjectHelper.isNotEmpty(endpointOptions = this.model.getEndpointOptions()) && ObjectHelper.isNotEmpty(this.options)) {
            for (String string : endpointOptions) {
                Object value2 = this.options.get(string);
                if (value2 == null) continue;
                this.doAddOption(options, string, this.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value2));
            }
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String key2 = (String)entry.getKey();
            String value3 = null;
            if (entry.getValue() != null) {
                value3 = entry.getValue().toString();
            }
            if (!this.isValidConnectionOption(key2, value3)) continue;
            this.doAddOption(options, key2, value3);
        }
        if (remaining != null && (map = this.catalog.endpointProperties(targetUri = this.componentScheme + ":" + remaining)) != null && !map.isEmpty()) {
            map.forEach((key, value) -> {
                if (this.isValidConnectionOption((String)key, (String)value)) {
                    this.doAddOption((Map)options, (String)key, (Object)value);
                }
            });
        }
        return options;
    }

    private boolean isValidConnectionOption(String key, String value) {
        return this.model.getScheduler() == null || DefaultConnectorComponent.asSchedulerKey(key) == null;
    }

    private static Constructor getPublicDefaultConstructor(Class<?> clazz) {
        for (Constructor<?> ctr : clazz.getConstructors()) {
            if (!Modifier.isPublic(ctr.getModifiers()) || ctr.getParameterCount() != 0) continue;
            return ctr;
        }
        return null;
    }
}

