/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.connector.DataType;
import org.apache.camel.json.simple.DeserializationException;
import org.apache.camel.json.simple.JsonObject;
import org.apache.camel.json.simple.Jsoner;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectorModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorModel.class);
    private final String componentName;
    private final String className;
    private String connectorJSon;
    private String baseScheme;
    private String baseJavaType;
    private String scheduler;
    private String connectorName;
    private DataType inputDataType;
    private DataType outputDataType;
    private Map<String, Object> defaultComponentOptions;
    private Map<String, Object> defaultEndpointOptions;
    private List<String> endpointOptions;
    private List<String> componentOptions;
    private Map<String, Object> connectorOptions;

    ConnectorModel(String componentName, Class<?> componentClass) {
        JsonObject json;
        this.componentName = componentName;
        this.className = componentClass.getName();
        this.connectorJSon = this.findCamelConnectorJSonSchema(componentClass);
        try {
            json = (JsonObject)Jsoner.deserialize((String)this.connectorJSon);
        }
        catch (DeserializationException e) {
            throw new RuntimeException("Error parsing camel-connector.json file due " + e.getMessage(), e);
        }
        this.connectorName = json.getString("name");
        this.baseScheme = json.getString("baseScheme");
        this.baseJavaType = json.getString("baseJavaType");
        this.scheduler = json.getString("scheduler");
        String type = json.getString("inputDataType");
        if (type != null) {
            this.inputDataType = new DataType(type);
        }
        if ((type = json.getString("outputDataType")) != null) {
            this.outputDataType = new DataType(type);
        }
        this.defaultComponentOptions = json.getMap("componentValues");
        if (this.defaultComponentOptions == null) {
            this.defaultComponentOptions = Collections.EMPTY_MAP;
        }
        this.defaultEndpointOptions = json.getMap("endpointValues");
        if (this.defaultEndpointOptions == null) {
            this.defaultEndpointOptions = Collections.EMPTY_MAP;
        }
        this.endpointOptions = (List)json.getCollection("endpointOptions");
        if (this.endpointOptions == null) {
            this.endpointOptions = Collections.EMPTY_LIST;
        }
        this.componentOptions = (List)json.getCollection("componentOptions");
        if (this.componentOptions == null) {
            this.componentOptions = Collections.EMPTY_LIST;
        }
        this.connectorOptions = json.getMap("connectorProperties");
        if (this.connectorOptions == null) {
            this.connectorOptions = Collections.EMPTY_MAP;
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getConnectorJSon() {
        return this.connectorJSon;
    }

    public String getBaseScheme() {
        return this.baseScheme;
    }

    public String getBaseJavaType() {
        return this.baseJavaType;
    }

    public String getScheduler() {
        return this.scheduler;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public DataType getInputDataType() {
        return this.inputDataType;
    }

    public DataType getOutputDataType() {
        return this.outputDataType;
    }

    public Map<String, Object> getDefaultComponentOptions() {
        return this.defaultComponentOptions;
    }

    public Map<String, Object> getDefaultEndpointOptions() {
        return this.defaultEndpointOptions;
    }

    public List<String> getEndpointOptions() {
        return this.endpointOptions;
    }

    public List<String> getComponentOptions() {
        return this.componentOptions;
    }

    public Map<String, Object> getConnectorOptions() {
        return this.connectorOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findCamelConnectorJSonSchema(Class<?> componentClass) {
        Enumeration<URL> urls;
        LOGGER.debug("Finding camel-connector.json in classpath for connector: {}", (Object)this.componentName);
        try {
            urls = componentClass.getClassLoader().getResources("camel-connector.json");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot open camel-connector.json in classpath for connector " + this.componentName);
        }
        while (urls.hasMoreElements()) {
            try {
                InputStream is = urls.nextElement().openStream();
                Throwable throwable = null;
                try {
                    String json = IOHelper.loadText((InputStream)is);
                    JsonObject output = (JsonObject)Jsoner.deserialize((String)json);
                    String javaType = output.getString("javaType");
                    LOGGER.debug("Found camel-connector.json in classpath with javaType: {}", (Object)javaType);
                    if (!this.className.equals(javaType)) continue;
                    String string = json;
                    return string;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot read camel-connector.json in classpath for connector " + this.componentName);
            }
        }
        return null;
    }
}

