/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="context")
public class ContextDevConsole
extends AbstractDevConsole {
    public ContextDevConsole() {
        super("camel", "context", "CamelContext", "Overall information about the CamelContext");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Apache Camel %s (%s) uptime %s", this.getCamelContext().getVersion(), this.getCamelContext().getName(), this.getCamelContext().getUptime()));
        sb.append("\n");
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getExtension(ManagedCamelContext.class);
        if (mcc != null) {
            ManagedCamelContextMBean mb = mcc.getManagedCamelContext();
            sb.append(String.format("\n    Total: %s", mb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mb.getExchangesInflight()));
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mb.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mb.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mb.getMinProcessingTime(), (boolean)true)));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        root.put((Object)"name", (Object)this.getCamelContext().getName());
        root.put((Object)"version", (Object)this.getCamelContext().getVersion());
        root.put((Object)"uptime", (Object)this.getCamelContext().getUptime());
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getExtension(ManagedCamelContext.class);
        if (mcc != null) {
            ManagedCamelContextMBean mb = mcc.getManagedCamelContext();
            JsonObject stats = new JsonObject();
            stats.put((Object)"exchangesTotal", (Object)mb.getExchangesTotal());
            stats.put((Object)"exchangesFailed", (Object)mb.getExchangesFailed());
            stats.put((Object)"exchangesInflight", (Object)mb.getExchangesInflight());
            stats.put((Object)"meanProcessingTime", (Object)mb.getMeanProcessingTime());
            stats.put((Object)"maxProcessingTime", (Object)mb.getMaxProcessingTime());
            stats.put((Object)"minProcessingTime", (Object)mb.getMinProcessingTime());
            root.put((Object)"statistics", (Object)stats);
        }
        return root;
    }
}

