/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.spi.BacklogTracer;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="trace")
@Configurer(bootstrap=true)
public class TraceDevConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="50", description="Maximum capacity of last number of messages to capture (capacity must be between 50 and 1000)")
    private int capacity = 50;
    private Queue<BacklogTracerEventMessage> queue;

    public TraceDevConsole() {
        super("camel", "trace", "Camel Tracing", "Trace routed messages");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    protected void doInit() throws Exception {
        if (this.capacity > 1000 || this.capacity < 50) {
            throw new IllegalArgumentException("Capacity must be between 50 and 1000");
        }
        this.queue = new LinkedBlockingQueue<BacklogTracerEventMessage>(this.capacity);
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        BacklogTracer tracer = (BacklogTracer)this.getCamelContext().getExtension(BacklogTracer.class);
        if (tracer != null) {
            for (BacklogTracerEventMessage t : tracer.dumpAllTracedMessages()) {
                this.addMessage(t);
            }
            for (BacklogTracerEventMessage t : this.queue) {
                String xml = t.toXml(0);
                sb.append(xml).append("\n");
            }
        }
        return sb.toString();
    }

    private void addMessage(BacklogTracerEventMessage message) {
        int drain = this.queue.size() - this.capacity + 1;
        if (drain > 0) {
            for (int i = 0; i < drain; ++i) {
                this.queue.poll();
            }
        }
        this.queue.add(message);
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        BacklogTracer tracer = (BacklogTracer)this.getCamelContext().getExtension(BacklogTracer.class);
        if (tracer != null) {
            for (BacklogTracerEventMessage t : tracer.dumpAllTracedMessages()) {
                this.addMessage(t);
            }
            ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
            root.put((Object)"traces", arr);
            for (BacklogTracerEventMessage t : this.queue) {
                JsonObject jo = (JsonObject)t.asJSon();
                arr.add(jo);
            }
        }
        return root;
    }
}

