/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="send", displayName="Camel Send", description="Send messages to endpoints")
@Configurer(extended=true)
public class SendDevConsole
extends AbstractDevConsole {
    private ProducerTemplate producer;
    private ConsumerTemplate consumer;
    @Metadata(defaultValue="32768", description="Maximum size of the message body to include in the dump")
    private int bodyMaxChars = 32768;
    @Metadata(defaultValue="20000", label="advanced", description="Timeout when using poll mode")
    private int pollTimeout = 20000;
    public static final String BODY_MAX_CHARS = "bodyMaxChars";
    public static final String BODY = "body";
    public static final String POLL = "poll";
    public static final String POLL_TIMEOUT = "pollTimeout";
    public static final String EXCHANGE_PATTERN = "exchangePattern";
    public static final String ENDPOINT = "endpoint";

    public SendDevConsole() {
        super("camel", "send", "Camel Send", "Send messages to endpoints");
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.consumer = this.getCamelContext().createConsumerTemplate();
        this.producer = this.getCamelContext().createProducerTemplate();
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object[])new Object[]{this.consumer, this.producer});
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public void setPollTimeout(int pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        StopWatch watch = new StopWatch();
        String endpoint = (String)options.get(ENDPOINT);
        String body = (String)options.getOrDefault(BODY, "");
        String exchangePattern = (String)options.get(EXCHANGE_PATTERN);
        boolean poll = "true".equals(options.get(POLL));
        int timeout = Integer.parseInt((String)options.getOrDefault(POLL_TIMEOUT, String.valueOf(this.pollTimeout)));
        timeout += 5000;
        Endpoint target = null;
        Exchange out = null;
        Exception cause = null;
        try {
            target = this.findTarget(endpoint);
            out = this.findToTarget(target, poll, timeout, exchangePattern, body, options);
        }
        catch (Exception e) {
            cause = e;
        }
        if (endpoint != null && target == null) {
            cause = new NoSuchEndpointException(endpoint);
        }
        if (out != null && out.getException() != null) {
            cause = out.getException();
        }
        long taken = watch.taken();
        String status = "success";
        if (cause != null) {
            status = "error";
        } else if (poll && out == null) {
            status = "timeout";
        }
        if (target != null) {
            sb.append(String.format("\n    Endpoint: %s", target));
        } else if (endpoint != null) {
            sb.append(String.format("\n    Endpoint: %s", endpoint));
        }
        sb.append(String.format("\n    Status: %s", status));
        sb.append(String.format("\n    Elapsed: %s", TimeUtils.printDuration((long)taken)));
        if (cause != null) {
            sb.append(String.format("\n    Error Message: %s", cause.getMessage()));
            String stackTrace = ExceptionHelper.stackTraceToString((Throwable)cause);
            sb.append("\n\n");
            sb.append(stackTrace);
            sb.append("\n\n");
        }
        if (out != null && (poll || "InOut".equals(exchangePattern))) {
            sb.append("\n    Response Message:\n");
            int maxChars = Integer.parseInt((String)options.getOrDefault(BODY_MAX_CHARS, "" + this.bodyMaxChars));
            String json = MessageHelper.dumpAsJSon((Message)out.getMessage(), (boolean)false, (boolean)false, (boolean)true, (int)2, (boolean)true, (boolean)true, (boolean)true, (int)maxChars, (boolean)true);
            sb.append(json);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        StopWatch watch = new StopWatch();
        long timestamp = System.currentTimeMillis();
        String endpoint = (String)options.get(ENDPOINT);
        String body = (String)options.getOrDefault(BODY, "");
        String exchangePattern = (String)options.get(EXCHANGE_PATTERN);
        boolean poll = "true".equals(options.get(POLL));
        int timeout = Integer.parseInt((String)options.getOrDefault(POLL_TIMEOUT, String.valueOf(this.pollTimeout)));
        timeout += 5000;
        Endpoint target = null;
        Exchange out = null;
        Exception cause = null;
        try {
            target = this.findTarget(endpoint);
            out = this.findToTarget(target, poll, timeout, exchangePattern, body, options);
        }
        catch (Exception e) {
            cause = e;
        }
        if (endpoint != null && target == null) {
            cause = new NoSuchEndpointException(endpoint);
        }
        if (out != null && out.getException() != null) {
            cause = out.getException();
        }
        long taken = watch.taken();
        String status = "success";
        if (cause != null) {
            status = "error";
        } else if (poll && out == null) {
            status = "timeout";
        }
        root.put((Object)"timestamp", (Object)timestamp);
        root.put((Object)"status", (Object)status);
        root.put((Object)"elapsed", (Object)taken);
        if (target != null) {
            root.put((Object)ENDPOINT, (Object)target.toString());
        } else if (endpoint != null) {
            root.put((Object)ENDPOINT, (Object)endpoint);
        }
        if (cause != null) {
            root.put((Object)"exception", (Object)MessageHelper.dumpExceptionAsJSonObject((Throwable)cause).getMap("exception"));
        }
        if (out != null && (poll || "InOut".equals(exchangePattern))) {
            root.put((Object)"exchangeId", (Object)out.getExchangeId());
            int maxChars = Integer.parseInt((String)options.getOrDefault(BODY_MAX_CHARS, "" + this.bodyMaxChars));
            root.put((Object)"message", (Object)MessageHelper.dumpAsJSonObject((Message)out.getMessage(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (int)maxChars).getMap("message"));
        }
        return root;
    }

    private Exchange findToTarget(Endpoint target, boolean poll, int timeout, String exchangePattern, String body, Map<String, Object> options) throws Exception {
        Exchange out = null;
        if (target != null) {
            Object inputBody = this.prepareBody(body);
            Map inputHeaders = this.prepareHeaders(options);
            if (poll) {
                out = this.consumer.receive(target, (long)timeout);
            } else {
                String mep = exchangePattern;
                out = this.producer.send(target, exchange -> {
                    exchange.getMessage().setBody(inputBody);
                    if (!inputHeaders.isEmpty()) {
                        exchange.getMessage().setHeaders(inputHeaders);
                    }
                    exchange.setPattern("InOut".equals(mep) ? ExchangePattern.InOut : ExchangePattern.InOnly);
                });
            }
            if (inputBody instanceof Closeable) {
                Closeable c = (Closeable)inputBody;
                IOHelper.close((Closeable)c);
            }
        }
        return out;
    }

    private Endpoint findTarget(String endpoint) {
        Endpoint target = null;
        if (endpoint == null) {
            List routes = this.getCamelContext().getRoutes();
            if (!routes.isEmpty()) {
                target = ((Route)routes.get(0)).getEndpoint();
            }
        } else {
            boolean scheme = ((String)endpoint).contains(":");
            boolean pattern = ((String)endpoint).endsWith("*");
            if (!scheme || pattern) {
                if (!scheme) {
                    endpoint = (String)endpoint + "*";
                }
                for (Route route : this.getCamelContext().getRoutes()) {
                    Endpoint e = route.getEndpoint();
                    if (!EndpointHelper.matchEndpoint((CamelContext)this.getCamelContext(), (String)e.getEndpointUri(), (String)endpoint)) continue;
                    target = e;
                    break;
                }
                if (target == null) {
                    for (Route route : this.getCamelContext().getRoutes()) {
                        String id = route.getRouteId();
                        Endpoint e = route.getEndpoint();
                        if (!EndpointHelper.matchEndpoint((CamelContext)this.getCamelContext(), (String)id, (String)endpoint)) continue;
                        target = e;
                        break;
                    }
                }
            } else {
                target = this.getCamelContext().getEndpoint((String)endpoint);
            }
        }
        return target;
    }

    private Object prepareBody(String body) throws Exception {
        Object b = body;
        if (body.startsWith("file:")) {
            File file = new File(body.substring(5));
            b = new FileInputStream(file);
        }
        return b;
    }

    private Map prepareHeaders(Map<String, Object> options) {
        HashMap answer = new HashMap();
        options.forEach((k, v) -> {
            if (SendDevConsole.isCustomHeader(k)) {
                answer.put(k, v);
            }
        });
        return answer;
    }

    private static boolean isCustomHeader(String key) {
        return !BODY.equals(key) && !BODY_MAX_CHARS.equals(key) && !POLL.equals(key) && !POLL_TIMEOUT.equals(key) && !EXCHANGE_PATTERN.equals(key) && !ENDPOINT.equals(key);
    }
}

