/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="bean", description="Displays Java beans from the registry")
public class BeanDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String PROPERTIES = "properties";
    public static final String NULLS = "nulls";
    public static final String INTERNAL = "internal";

    public BeanDevConsole() {
        super("camel", "bean", "Bean", "Displays Java beans from the registry");
    }

    protected String doCallText(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        boolean properties = "true".equals(options.getOrDefault(PROPERTIES, "true").toString());
        boolean nulls = "true".equals(options.getOrDefault(NULLS, "true").toString());
        boolean internal = "true".equals(options.getOrDefault(INTERNAL, "true").toString());
        StringBuilder sb = new StringBuilder();
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
        Map beans = this.getCamelContext().getRegistry().findByTypeWithName(Object.class);
        Stream<String> keys = beans.keySet().stream().filter(r -> BeanDevConsole.accept(r, filter)).sorted(String::compareToIgnoreCase);
        keys.forEach(k -> {
            Object bean = beans.get(k);
            if (bean != null) {
                boolean include;
                boolean bl = include = internal || !bean.getClass().getName().startsWith("org.apache.camel.");
                if (include) {
                    sb.append(String.format("    %s (class: %s)%n", k, bean.getClass().getName()));
                    TreeMap<String, Object> values = new TreeMap<String, Object>();
                    if (properties) {
                        try {
                            bi.getProperties(bean, values, null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        values.forEach((pk, pv) -> {
                            if (pv == null) {
                                if (nulls) {
                                    sb.append(String.format("        %s = null%n", pk));
                                }
                            } else {
                                String t = pv.getClass().getName();
                                sb.append(String.format("        %s (%s) = %s%n", pk, t, pv));
                            }
                        });
                    }
                }
            }
            sb.append("\n");
        });
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        boolean properties = "true".equals(options.getOrDefault(PROPERTIES, "true").toString());
        boolean nulls = "true".equals(options.getOrDefault(NULLS, "true").toString());
        boolean internal = "true".equals(options.getOrDefault(INTERNAL, "true").toString());
        JsonObject root = new JsonObject();
        JsonObject jo = new JsonObject();
        root.put((Object)"beans", (Object)jo);
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
        Map beans = this.getCamelContext().getRegistry().findByTypeWithName(Object.class);
        Stream<String> keys = beans.keySet().stream().filter(r -> BeanDevConsole.accept(r, filter)).sorted(String::compareToIgnoreCase);
        keys.forEach(k -> {
            Object bean = beans.get(k);
            if (bean != null) {
                boolean include;
                boolean bl = include = internal || !bean.getClass().getName().startsWith("org.apache.camel.");
                if (include) {
                    TreeMap<String, Object> values = new TreeMap<String, Object>();
                    if (properties) {
                        try {
                            bi.getProperties(bean, values, null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    JsonObject jb = new JsonObject();
                    jb.put((Object)"name", k);
                    jb.put((Object)"type", (Object)bean.getClass().getName());
                    jo.put(k, (Object)jb);
                    if (!values.isEmpty()) {
                        JsonArray arr = new JsonArray();
                        values.forEach((pk, pv) -> {
                            boolean accept;
                            String type;
                            Object value = pv;
                            String string = type = pv != null ? pv.getClass().getName() : null;
                            if (type != null) {
                                value = Jsoner.trySerialize((Object)pv);
                                value = value == null ? Jsoner.escape((String)pv.toString()) : pv;
                            }
                            JsonObject jp = new JsonObject();
                            jp.put((Object)"name", pk);
                            if (type != null) {
                                jp.put((Object)"type", (Object)type);
                            }
                            jp.put((Object)"value", value);
                            boolean bl = accept = value != null || nulls;
                            if (accept) {
                                arr.add((Object)jp);
                            }
                        });
                        jb.put((Object)PROPERTIES, (Object)arr);
                    }
                }
            }
        });
        return root;
    }

    private static boolean accept(String name, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)name, (String)filter);
    }
}

