/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="jvm", displayName="JVM", description="Displays JVM information")
@Configurer(extended=true)
public class JvmDevConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="true", description="Show classpath information")
    private boolean showClasspath = true;

    public JvmDevConsole() {
        super("jvm", "jvm", "JVM", "Displays JVM information");
    }

    public boolean isShowClasspath() {
        return this.showClasspath;
    }

    public void setShowClasspath(boolean showClasspath) {
        this.showClasspath = showClasspath;
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        RuntimeMXBean mb = ManagementFactory.getRuntimeMXBean();
        if (mb != null) {
            String cp;
            sb.append(String.format("Java Name: %s\n", mb.getVmName()));
            sb.append(String.format("Java Version: %s\n", mb.getVmVersion()));
            sb.append(String.format("Java Vendor: %s\n", mb.getVmVendor()));
            sb.append(String.format("Uptime: %s\n", TimeUtils.printDuration((long)mb.getUptime())));
            sb.append(String.format("PID: %s\n", mb.getPid()));
            if (!mb.getInputArguments().isEmpty()) {
                sb.append("Input Arguments:");
                String arg = String.join((CharSequence)"\n    ", mb.getInputArguments());
                sb.append("\n    ").append(arg).append("\n");
            }
            if (mb.isBootClassPathSupported()) {
                sb.append("Boot Classpath:");
                cp = String.join((CharSequence)"\n    ", mb.getBootClassPath().split("[:|;]"));
                sb.append("\n    ").append(cp).append("\n");
            }
            sb.append("Classpath:");
            cp = String.join((CharSequence)"\n    ", mb.getClassPath().split("[:|;]"));
            sb.append("\n    ").append(cp).append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        RuntimeMXBean mb = ManagementFactory.getRuntimeMXBean();
        if (mb != null) {
            String[] cp;
            root.put((Object)"vmName", (Object)mb.getVmName());
            root.put((Object)"vmVersion", (Object)mb.getVmVersion());
            root.put((Object)"vmVendor", (Object)mb.getVmVendor());
            root.put((Object)"vmUptime", (Object)TimeUtils.printDuration((long)mb.getUptime()));
            root.put((Object)"pid", (Object)mb.getPid());
            if (!mb.getInputArguments().isEmpty()) {
                String arg = String.join((CharSequence)" ", mb.getInputArguments());
                root.put((Object)"inputArguments", (Object)arg);
            }
            if (mb.isBootClassPathSupported()) {
                cp = mb.getBootClassPath().split("[:|;]");
                root.put((Object)"bootClasspath", (Object)cp);
            }
            cp = mb.getClassPath().split("[:|;]");
            root.put((Object)"classpath", (Object)cp);
        }
        return root;
    }
}

