/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.support.task.Task;
import org.apache.camel.support.task.TaskManagerRegistry;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="internal-tasks", displayName="Internal Tasks", description="Display information about internal tasks")
public class TaskRegistryDevConsole
extends AbstractDevConsole {
    public TaskRegistryDevConsole() {
        super("camel", "internal-tasks", "Internal Tasks", "Display information about internal tasks");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        TaskManagerRegistry reg = PluginHelper.getTaskManagerRegistry((ExtendedCamelContext)this.getCamelContext().getCamelContextExtension());
        sb.append(String.format("\nTasks: %s", reg.getSize()));
        int id = 0;
        for (Task task : reg.getTasks()) {
            String failure = task.getException() != null ? task.getException().getMessage() : "";
            sb.append(String.format("\n    #%d (name=%s status=%s attempts=%d delay=%d elapsed=%d first=%d last=%d next=%d failure=%s", id, task.getName(), task.getStatus().name(), task.iteration(), task.getCurrentDelay(), task.getCurrentElapsedTime(), task.getFirstAttemptTime(), task.getLastAttemptTime(), task.getNextAttemptTime(), failure));
            ++id;
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        root.put((Object)"tasks", (Object)arr);
        TaskManagerRegistry reg = PluginHelper.getTaskManagerRegistry((ExtendedCamelContext)this.getCamelContext().getCamelContextExtension());
        for (Task task : reg.getTasks()) {
            String failure;
            JsonObject jo = new JsonObject();
            jo.put((Object)"name", (Object)task.getName());
            jo.put((Object)"status", (Object)task.getStatus().name());
            jo.put((Object)"attempts", (Object)task.iteration());
            jo.put((Object)"delay", (Object)task.getCurrentDelay());
            jo.put((Object)"elapsed", (Object)task.getCurrentElapsedTime());
            jo.put((Object)"firstTime", (Object)task.getFirstAttemptTime());
            jo.put((Object)"lastTime", (Object)task.getLastAttemptTime());
            jo.put((Object)"nextTime", (Object)task.getNextAttemptTime());
            String string = failure = task.getException() != null ? task.getException().getMessage() : "";
            if (failure != null) {
                jo.put((Object)"error", (Object)failure);
            }
            arr.add((Object)jo);
        }
        return root;
    }
}

