/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.camel.Route;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(value="route-controller")
public class RouteControllerConsole
extends AbstractDevConsole {
    public static final String STACKTRACE = "stacktrace";
    public static final String ERROR = "error";

    public RouteControllerConsole() {
        super("camel", "route-controller", "Route Controller", "Route startup information");
    }

    protected String doCallText(Map<String, Object> options) {
        boolean includeError = "true".equals(options.getOrDefault(ERROR, "true"));
        boolean includeStacktrace = "true".equals(options.getOrDefault(STACKTRACE, "true"));
        StringBuilder sb = new StringBuilder();
        RouteController rc = this.getCamelContext().getRouteController();
        if (rc instanceof SupervisingRouteController) {
            SupervisingRouteController src = (SupervisingRouteController)rc;
            TreeSet<Route> routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
            routes.addAll(rc.getControlledRoutes());
            routes.addAll(src.getExhaustedRoutes());
            routes.addAll(src.getRestartingRoutes());
            long started = routes.stream().filter(r -> src.getRouteStatus(r.getRouteId()).isStarted()).count();
            sb.append(String.format("Total Routes: %d", routes.size()));
            sb.append(String.format("\nStarted Routes: %d", started));
            sb.append(String.format("\nRestarting Routes: %d", src.getRestartingRoutes().size()));
            sb.append(String.format("\nExhausted Routes: %d", src.getExhaustedRoutes().size()));
            sb.append(String.format("\nInitial Delay: %d", src.getInitialDelay()));
            sb.append(String.format("\nBackoff Delay: %d", src.getBackOffDelay()));
            sb.append(String.format("\nBackoff Max Delay: %d", src.getBackOffMaxDelay()));
            sb.append(String.format("\nBackoff Max Elapsed Time: %d", src.getBackOffMaxElapsedTime()));
            sb.append(String.format("\nBackoff Max Attempts: %d", src.getBackOffMaxAttempts()));
            sb.append(String.format("\nThread Pool Size: %d", src.getThreadPoolSize()));
            sb.append(String.format("\nUnhealthy On Exhaust: %b", src.isUnhealthyOnExhausted()));
            sb.append("\n\nRoutes:\n");
            for (Route route : routes) {
                long time;
                String routeId = route.getRouteId();
                String status = src.getRouteStatus(routeId).name();
                String uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                BackOffTimer.Task state = src.getRestartingRouteState(routeId);
                String supervising = state != null ? state.getStatus().name() : null;
                long attempts = state != null ? state.getCurrentAttempts() : 0L;
                String elapsed = "";
                String last = "";
                String next = "";
                long l = time = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getFirstAttemptTime() : 0L;
                if (time > 0L) {
                    elapsed = TimeUtils.printDuration((long)time);
                }
                long l2 = time = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getLastAttemptTime() : 0L;
                if (time > 0L) {
                    last = TimeUtils.printSince((long)time);
                }
                long l3 = time = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getNextAttemptTime() : 0L;
                if (time > 0L) {
                    next = TimeUtils.printSince((long)time);
                }
                String error = null;
                String stacktrace = null;
                Throwable cause = src.getRestartException(routeId);
                if (includeError && cause != null) {
                    error = cause.getMessage();
                    if (includeStacktrace) {
                        StringWriter writer = new StringWriter();
                        cause.printStackTrace(new PrintWriter(writer));
                        writer.flush();
                        stacktrace = writer.toString();
                    }
                }
                if (supervising != null) {
                    sb.append(String.format("\n    %s %s (%s) ", status, routeId, uri));
                    sb.append(String.format("\n        Supervising: %s", supervising));
                    sb.append(String.format("\n            Attempts: %s", attempts));
                    sb.append(String.format("\n            Last Ago: %s", last));
                    sb.append(String.format("\n            Next Attempt: %s", next));
                    sb.append(String.format("\n            Elapsed: %s", elapsed));
                    if (error == null) continue;
                    sb.append(String.format("\n            Error: %s", error));
                    if (stacktrace == null) continue;
                    sb.append(String.format("\n            Stacktrace:\n%s", stacktrace));
                    continue;
                }
                sb.append(String.format("\n    %s %s (%s) ", status, routeId, uri));
            }
        } else {
            TreeSet<Route> routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
            routes.addAll(rc.getControlledRoutes());
            if (routes.isEmpty()) {
                routes.addAll(this.getCamelContext().getRoutes());
            }
            sb.append(String.format("Total Routes: %d", routes.size()));
            sb.append("\nRoutes:\n");
            for (Route route : routes) {
                String routeId = route.getRouteId();
                String status = rc.getRouteStatus(routeId).name();
                String uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                sb.append(String.format("\n    %s %s (%s)", status, routeId, uri));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        boolean includeError = "true".equals(options.getOrDefault(ERROR, "true"));
        boolean includeStacktrace = "true".equals(options.getOrDefault(STACKTRACE, "true"));
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        RouteController rc = this.getCamelContext().getRouteController();
        if (rc instanceof SupervisingRouteController) {
            SupervisingRouteController src = (SupervisingRouteController)rc;
            TreeSet<Route> routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
            routes.addAll(rc.getControlledRoutes());
            routes.addAll(src.getExhaustedRoutes());
            routes.addAll(src.getRestartingRoutes());
            long started = routes.stream().filter(r -> src.getRouteStatus(r.getRouteId()).isStarted()).count();
            root.put((Object)"controller", (Object)"SupervisingRouteController");
            root.put((Object)"totalRoutes", (Object)routes.size());
            root.put((Object)"startedRoutes", (Object)started);
            root.put((Object)"restartingRoutes", (Object)src.getRestartingRoutes().size());
            root.put((Object)"exhaustedRoutes", (Object)src.getExhaustedRoutes().size());
            root.put((Object)"initialDelay", (Object)src.getInitialDelay());
            root.put((Object)"backoffDelay", (Object)src.getBackOffDelay());
            root.put((Object)"backoffMaxDelay", (Object)src.getBackOffMaxDelay());
            root.put((Object)"backoffMaxElapsedTime", (Object)src.getBackOffMaxElapsedTime());
            root.put((Object)"backoffMaxAttempts", (Object)src.getBackOffMaxAttempts());
            root.put((Object)"threadPoolSize", (Object)src.getThreadPoolSize());
            root.put((Object)"unhealthyOnExhausted", (Object)src.isUnhealthyOnExhausted());
            root.put((Object)"routes", list);
            for (Route route : routes) {
                String routeId = route.getRouteId();
                String status = rc.getRouteStatus(routeId).name();
                String uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                BackOffTimer.Task state = src.getRestartingRouteState(routeId);
                String supervising = state != null ? state.getStatus().name() : null;
                long attempts = state != null ? state.getCurrentAttempts() : 0L;
                long elapsed = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getCurrentElapsedTime() : 0L;
                long last = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getLastAttemptTime() : 0L;
                long next = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getNextAttemptTime() : 0L;
                JsonObject jo = new JsonObject();
                list.add(jo);
                jo.put((Object)"routeId", (Object)routeId);
                jo.put((Object)"status", (Object)status);
                jo.put((Object)"uri", (Object)uri);
                jo.put((Object)"attempts", (Object)attempts);
                jo.put((Object)"lastAttempt", (Object)last);
                jo.put((Object)"nextAttempt", (Object)next);
                jo.put((Object)"elapsed", (Object)elapsed);
                if (supervising == null) continue;
                jo.put((Object)"supervising", (Object)supervising);
                Throwable cause = src.getRestartException(routeId);
                if (!includeError || cause == null) continue;
                String error = cause.getMessage();
                jo.put((Object)ERROR, (Object)Jsoner.escape((String)error));
                if (!includeStacktrace) continue;
                JsonArray arr2 = new JsonArray();
                StringWriter writer = new StringWriter();
                cause.printStackTrace(new PrintWriter(writer));
                writer.flush();
                String trace = writer.toString();
                jo.put((Object)"stackTrace", (Object)arr2);
                Collections.addAll(arr2, trace.split("\n"));
            }
        } else {
            TreeSet<Route> routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
            routes.addAll(rc.getControlledRoutes());
            if (routes.isEmpty()) {
                routes.addAll(this.getCamelContext().getRoutes());
            }
            root.put((Object)"controller", (Object)"DefaultRouteController");
            root.put((Object)"totalRoutes", (Object)routes.size());
            root.put((Object)"routes", list);
            for (Route route : routes) {
                String routeId = route.getRouteId();
                String status = rc.getRouteStatus(routeId).name();
                String uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                JsonObject jo = new JsonObject();
                list.add(jo);
                jo.put((Object)"routeId", (Object)routeId);
                jo.put((Object)"status", (Object)status);
                jo.put((Object)"uri", (Object)uri);
            }
        }
        return root;
    }
}

