/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.enpoint.ConsulAgentProducer;
import org.apache.camel.component.consul.enpoint.ConsulEventConsumer;
import org.apache.camel.component.consul.enpoint.ConsulEventProducer;
import org.apache.camel.component.consul.enpoint.ConsulKeyValueConsumer;
import org.apache.camel.component.consul.enpoint.ConsulKeyValueProducer;
import org.apache.camel.impl.UriEndpointComponent;

public class ConsulComponent
extends UriEndpointComponent {
    public ConsulComponent() {
        super(ConsulEndpoint.class);
    }

    public ConsulComponent(CamelContext context) {
        super(context, ConsulEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return ConsulApiEndpoint.valueOf(remaining).create(remaining, uri, this, this.createConfiguration(parameters));
    }

    private ConsulConfiguration createConfiguration(Map<String, Object> parameters) throws Exception {
        ConsulConfiguration configuration = new ConsulConfiguration(this.getCamelContext());
        this.setProperties(configuration, parameters);
        return configuration;
    }

    private static enum ConsulApiEndpoint {
        kv(ConsulKeyValueProducer::new, ConsulKeyValueConsumer::new),
        event(ConsulEventProducer::new, ConsulEventConsumer::new),
        agent(ConsulAgentProducer::new, null);

        private final ConsulEndpoint.ProducerFactory producerFactory;
        private final ConsulEndpoint.ConsumerFactory consumerFactory;

        private ConsulApiEndpoint(ConsulEndpoint.ProducerFactory producerFactory, ConsulEndpoint.ConsumerFactory consumerFactory) {
            this.producerFactory = producerFactory;
            this.consumerFactory = consumerFactory;
        }

        public Endpoint create(String apiEndpoint, String uri, ConsulComponent component, ConsulConfiguration configuration) throws Exception {
            return new ConsulEndpoint(apiEndpoint, uri, component, configuration, this.producerFactory, this.consumerFactory);
        }
    }
}

