/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.processor.remote;

import com.orbitz.consul.model.catalog.CatalogService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.processor.remote.ConsulServiceCallServerListStrategy;
import org.apache.camel.spi.ServiceCallServer;

public final class ConsulServiceCallServerListStrategies {
    private ConsulServiceCallServerListStrategies() {
    }

    public static ConsulServiceCallServerListStrategy onDemand(ConsulConfiguration configuration) throws Exception {
        return new OnDemand(configuration);
    }

    public static final class OnDemand
    extends ConsulServiceCallServerListStrategy {
        public OnDemand(ConsulConfiguration configuration) throws Exception {
            super(configuration);
        }

        public List<ServiceCallServer> getUpdatedListOfServers(String name) {
            List services = (List)this.getCatalogClient().getService(name, this.getCatalogOptions()).getResponse();
            List healths = (List)this.getHealthClient().getAllServiceInstances(name, this.getCatalogOptions()).getResponse();
            return services.stream().filter(service -> !this.hasFailingChecks((CatalogService)service, healths)).map(this::newServer).collect(Collectors.toList());
        }

        @Override
        public String toString() {
            return "OnDemand";
        }
    }
}

