/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.orbitz.consul.Consul;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.impl.HeaderSelectorProducer;

public abstract class AbstractConsulProducer<C>
extends HeaderSelectorProducer {
    private final ConsulEndpoint endpoint;
    private final ConsulConfiguration configuration;
    private final Function<Consul, C> clientSupplier;
    private C client;

    protected AbstractConsulProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration, Function<Consul, C> clientSupplier) {
        super((Endpoint)endpoint, "CamelConsulAction", configuration.getAction());
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.clientSupplier = clientSupplier;
        this.client = null;
    }

    protected Consul getConsul() throws Exception {
        return this.endpoint.getConsul();
    }

    protected C getClient() throws Exception {
        if (this.client == null) {
            this.client = this.clientSupplier.apply(this.getConsul());
        }
        return this.client;
    }

    protected ConsulConfiguration getConfiguration() {
        return this.configuration;
    }

    protected <D> D getHeader(Message message, String header, D defaultValue, Class<D> type) {
        return (D)message.getHeader(header, defaultValue, type);
    }

    protected <D> D getMandatoryHeader(Message message, String header, Class<D> type) throws Exception {
        return this.getMandatoryHeader(message, header, null, type);
    }

    protected <D> D getMandatoryHeader(Message message, String header, D defaultValue, Class<D> type) throws Exception {
        D value = this.getHeader(message, header, defaultValue, type);
        if (value == null) {
            throw new NoSuchHeaderException(message.getExchange(), header, type);
        }
        return value;
    }

    protected String getKey(Message message) {
        return (String)message.getHeader("CamelConsulKey", (Object)this.configuration.getKey(), String.class);
    }

    protected String getMandatoryKey(Message message) throws Exception {
        return this.getMandatoryHeader(message, "CamelConsulKey", this.configuration.getKey(), String.class);
    }

    protected <T> T getOption(Message message, T defaultValue, Class<T> type) {
        return (T)message.getHeader("CamelConsulOptions", defaultValue, type);
    }

    protected boolean isValueAsString(Message message) throws Exception {
        return (Boolean)message.getHeader("CamelConsulValueAsString", (Object)this.configuration.isValueAsString(), Boolean.class);
    }

    protected <T> T getBody(Message message, T defaultValue, Class<T> type) throws Exception {
        Object body = message.getBody(type);
        if (body == null) {
            body = defaultValue;
        }
        return (T)body;
    }

    protected void setBodyAndResult(Message message, Object body) throws Exception {
        this.setBodyAndResult(message, body, body != null);
    }

    protected void setBodyAndResult(Message message, Object body, boolean result) throws Exception {
        message.setHeader("CamelConsulResult", (Object)result);
        if (body != null) {
            message.setBody(body);
        }
    }

    protected Processor wrap(Function<C, Object> supplier) {
        return exchange -> this.setBodyAndResult(exchange.getIn(), supplier.apply(this.getClient()));
    }
}

