/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.orbitz.consul.Consul;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;

@UriParams
public class ConsulConfiguration {
    @UriParam
    private String url;
    @UriParam
    private String dc;
    @UriParam(javaType="java.lang.String")
    private Set<String> tags;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security", secret=true)
    private String aclToken;
    @UriParam(label="security", secret=true)
    private String userName;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam
    private Long connectTimeoutMillis;
    @UriParam
    private Long readTimeoutMillis;
    @UriParam
    private Long writeTimeoutMillis;
    @UriParam(defaultValue="true")
    private boolean pingInstance = true;
    @UriParam
    private String key;
    @UriParam(label="producer")
    private String action;
    @UriParam(label="producer", defaultValue="false")
    private boolean valueAsString;
    @UriParam(label="consumer,watch", defaultValue="10")
    private Integer blockSeconds = 10;
    @UriParam(label="consumer,watch", defaultValue="0")
    private long firstIndex;
    @UriParam(label="consumer,watch", defaultValue="false")
    private boolean recursive;
    private final CamelContext context;

    public ConsulConfiguration(CamelContext context) {
        this.context = context;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setTags(String tagsAsString) {
        this.tags = new HashSet<String>();
        Collections.addAll(this.tags, tagsAsString.split(","));
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public String getAction() {
        return this.action;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean requiresBasicAuthentication() {
        return ObjectHelper.isNotEmpty((Object)this.userName) && ObjectHelper.isNotEmpty((Object)this.password);
    }

    public Long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(Long connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public Long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(Long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public Long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public void setWriteTimeoutMillis(Long writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    public boolean isPingInstance() {
        return this.pingInstance;
    }

    public void setPingInstance(boolean pingInstance) {
        this.pingInstance = pingInstance;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isValueAsString() {
        return this.valueAsString;
    }

    public void setValueAsString(boolean valueAsString) {
        this.valueAsString = valueAsString;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getBlockSeconds() {
        return this.blockSeconds;
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.blockSeconds = blockSeconds;
    }

    public long getFirstIndex() {
        return this.firstIndex;
    }

    public void setFirstIndex(long firstIndex) {
        this.firstIndex = firstIndex;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Consul createConsulClient() throws Exception {
        Consul.Builder builder = Consul.builder();
        builder.withPing(this.pingInstance);
        if (ObjectHelper.isNotEmpty((Object)this.url)) {
            builder.withUrl(this.url);
        }
        if (ObjectHelper.isNotEmpty((Object)this.context) && ObjectHelper.isNotEmpty((Object)this.sslContextParameters)) {
            builder.withSslContext(this.sslContextParameters.createSSLContext(this.context));
        }
        if (ObjectHelper.isNotEmpty((Object)this.aclToken)) {
            builder.withAclToken(this.aclToken);
        }
        if (this.requiresBasicAuthentication()) {
            builder.withBasicAuth(this.userName, this.password);
        }
        if (ObjectHelper.isNotEmpty((Object)this.connectTimeoutMillis)) {
            builder.withConnectTimeoutMillis(this.connectTimeoutMillis.longValue());
        }
        if (ObjectHelper.isNotEmpty((Object)this.readTimeoutMillis)) {
            builder.withReadTimeoutMillis(this.readTimeoutMillis.longValue());
        }
        if (ObjectHelper.isNotEmpty((Object)this.writeTimeoutMillis)) {
            builder.withWriteTimeoutMillis(this.writeTimeoutMillis.longValue());
        }
        return builder.build();
    }
}

