/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.orbitz.consul.Consul;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.consul.ConsulComponent;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="consul", title="Consul", syntax="consul:apiEndpoint", label="api,cloud")
public class ConsulEndpoint
extends DefaultEndpoint {
    @UriParam(description="The consul configuration")
    @Metadata
    private final ConsulConfiguration configuration;
    @UriPath(description="The API endpoint")
    @Metadata(required="true")
    private final String apiEndpoint;
    private final ProducerFactory producerFactory;
    private final ConsumerFactory consumerFactory;
    private Consul consul;

    public ConsulEndpoint(String apiEndpoint, String uri, ConsulComponent component, ConsulConfiguration configuration, ProducerFactory producerFactory, ConsumerFactory consumerFactory) {
        super(uri, (Component)component);
        this.configuration = (ConsulConfiguration)ObjectHelper.notNull((Object)configuration, (String)"configuration");
        this.apiEndpoint = (String)ObjectHelper.notNull((Object)apiEndpoint, (String)"apiEndpoint");
        this.producerFactory = producerFactory;
        this.consumerFactory = consumerFactory;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        if (this.producerFactory == null) {
            throw new IllegalArgumentException("No producer for " + this.apiEndpoint);
        }
        return this.producerFactory.create(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.consumerFactory == null) {
            throw new IllegalArgumentException("No consumer for " + this.apiEndpoint);
        }
        return this.consumerFactory.create(this, this.configuration, processor);
    }

    public ConsulConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public synchronized Consul getConsul() throws Exception {
        if (this.consul == null) {
            this.consul = this.configuration.createConsulClient();
        }
        return this.consul;
    }

    @FunctionalInterface
    public static interface ConsumerFactory {
        public Consumer create(ConsulEndpoint var1, ConsulConfiguration var2, Processor var3) throws Exception;
    }

    @FunctionalInterface
    public static interface ProducerFactory {
        public Producer create(ConsulEndpoint var1, ConsulConfiguration var2) throws Exception;
    }
}

