/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.processor.remote;

import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.ImmutableCatalogOptions;
import java.util.List;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.impl.remote.DefaultServiceCallServer;
import org.apache.camel.impl.remote.DefaultServiceCallServerListStrategy;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.util.ObjectHelper;

abstract class ConsulServiceCallServerListStrategy
extends DefaultServiceCallServerListStrategy<ServiceCallServer> {
    private final Consul client;
    private final CatalogOptions catalogOptions;

    ConsulServiceCallServerListStrategy(ConsulConfiguration configuration) throws Exception {
        this.client = configuration.createConsulClient();
        ImmutableCatalogOptions.Builder builder = ImmutableCatalogOptions.builder();
        if (ObjectHelper.isNotEmpty((Object)configuration.getDc())) {
            builder.datacenter(configuration.getDc());
        }
        if (ObjectHelper.isNotEmpty(configuration.getTags())) {
            configuration.getTags().forEach(arg_0 -> ((ImmutableCatalogOptions.Builder)builder).tag(arg_0));
        }
        this.catalogOptions = builder.build();
    }

    public String toString() {
        return "ConsulServiceCallServerListStrategy";
    }

    protected Consul getClient() {
        return this.client;
    }

    protected CatalogClient getCatalogClient() {
        return this.client.catalogClient();
    }

    protected HealthClient getHealthClient() {
        return this.client.healthClient();
    }

    protected CatalogOptions getCatalogOptions() {
        return this.catalogOptions;
    }

    protected boolean isNotHealthy(HealthCheck check) {
        String status = check.getStatus();
        return status != null && !status.equalsIgnoreCase("passing");
    }

    protected boolean isNotHealthy(ServiceHealth health) {
        return health.getChecks().stream().anyMatch(this::isNotHealthy);
    }

    protected boolean isCheckOnService(ServiceHealth check, CatalogService service) {
        return check.getService().getService().equalsIgnoreCase(service.getServiceName());
    }

    protected boolean hasFailingChecks(CatalogService service, List<ServiceHealth> healths) {
        return healths.stream().anyMatch(health -> this.isCheckOnService((ServiceHealth)health, service) && this.isNotHealthy((ServiceHealth)health));
    }

    protected ServiceCallServer newServer(CatalogService service) {
        return new DefaultServiceCallServer(service.getServiceAddress(), service.getServicePort());
    }
}

