/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.enpoint;

import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.option.PutOptions;
import com.orbitz.consul.option.QueryOptions;
import java.util.List;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.consul.AbstractConsulProducer;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;

public class ConsulKeyValueProducer
extends AbstractConsulProducer<KeyValueClient> {
    public ConsulKeyValueProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, c -> c.keyValueClient());
    }

    @InvokeOnHeader(value="PUT")
    protected void put(Message message) throws Exception {
        message.setHeader("CamelConsulResult", (Object)((KeyValueClient)this.getClient()).putValue(this.getMandatoryKey(message), (String)message.getBody(String.class), ((Long)message.getHeader("CamelConsulFlags", (Object)0L, Long.class)).longValue(), this.getOption(message, PutOptions.BLANK, PutOptions.class)));
    }

    @InvokeOnHeader(value="GET_VALUE")
    protected void getValue(Message message) throws Exception {
        Object result = this.isValueAsString(message) ? ((KeyValueClient)this.getClient()).getValueAsString(this.getMandatoryKey(message)).orNull() : ((KeyValueClient)this.getClient()).getValue(this.getMandatoryKey(message), this.getOption(message, QueryOptions.BLANK, QueryOptions.class)).orNull();
        this.setBodyAndResult(message, result);
    }

    @InvokeOnHeader(value="GET_VALUES")
    protected void getValues(Message message) throws Exception {
        List result = this.isValueAsString(message) ? ((KeyValueClient)this.getClient()).getValuesAsString(this.getMandatoryKey(message)) : ((KeyValueClient)this.getClient()).getValues(this.getMandatoryKey(message), this.getOption(message, QueryOptions.BLANK, QueryOptions.class));
        this.setBodyAndResult(message, result);
    }

    @InvokeOnHeader(value="GET_KEYS")
    protected void getKeys(Message message) throws Exception {
        this.setBodyAndResult(message, ((KeyValueClient)this.getClient()).getKeys(this.getMandatoryKey(message)));
    }

    @InvokeOnHeader(value="GET_SESSIONS")
    protected void getSessions(Message message) throws Exception {
        this.setBodyAndResult(message, ((KeyValueClient)this.getClient()).getSession(this.getMandatoryKey(message)));
    }

    @InvokeOnHeader(value="DELETE_KEY")
    protected void deleteKey(Message message) throws Exception {
        ((KeyValueClient)this.getClient()).deleteKey(this.getMandatoryKey(message));
        message.setHeader("CamelConsulResult", (Object)true);
    }

    @InvokeOnHeader(value="DELETE_KEYS")
    protected void deleteKeys(Message message) throws Exception {
        ((KeyValueClient)this.getClient()).deleteKeys(this.getMandatoryKey(message));
        message.setHeader("CamelConsulResult", (Object)true);
    }

    @InvokeOnHeader(value="LOCK")
    protected void lock(Message message) throws Exception {
        message.setHeader("CamelConsulResult", (Object)((KeyValueClient)this.getClient()).acquireLock(this.getMandatoryKey(message), this.getBody(message, null, String.class), (String)message.getHeader("CamelConsulSession", (Object)"", String.class)));
    }

    @InvokeOnHeader(value="UNLOCK")
    protected void unlock(Message message) throws Exception {
        message.setHeader("CamelConsulResult", (Object)((KeyValueClient)this.getClient()).releaseLock(this.getMandatoryKey(message), this.getMandatoryHeader(message, "CamelConsulSession", String.class)));
    }
}

