/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.policy;

import com.google.common.base.Optional;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.model.session.ImmutableSession;
import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRoutePolicy
extends RoutePolicySupport
implements NonManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulRoutePolicy.class);
    private final Object lock;
    private final Consul consul;
    private final SessionClient sessionClient;
    private final KeyValueClient keyValueClient;
    private final AtomicBoolean leader;
    private final Set<Route> suspendedRoutes;
    private final AtomicReference<BigInteger> index;
    private String serviceName;
    private String servicePath;
    private int ttl;
    private int lockDelay;
    private ExecutorService executorService;
    private boolean shouldStopConsumer;
    private String sessionId;

    public ConsulRoutePolicy() {
        this(Consul.builder().build());
    }

    public ConsulRoutePolicy(Consul consul) {
        this.consul = consul;
        this.sessionClient = consul.sessionClient();
        this.keyValueClient = consul.keyValueClient();
        this.suspendedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean(false);
        this.lock = new Object();
        this.index = new AtomicReference<BigInteger>(BigInteger.valueOf(0L));
        this.serviceName = null;
        this.servicePath = null;
        this.ttl = 60;
        this.lockDelay = 10;
        this.executorService = null;
        this.shouldStopConsumer = true;
        this.sessionId = null;
    }

    public void onStart(Route route) {
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onSuspend(Route route) {
        Object object = this.lock;
        synchronized (object) {
            this.suspendedRoutes.remove(route);
        }
    }

    protected void doStart() throws Exception {
        if (this.sessionId == null) {
            this.sessionId = this.sessionClient.createSession((Session)ImmutableSession.builder().name(this.serviceName).ttl(this.ttl + "s").lockDelay(this.lockDelay + "s").build()).getId();
            LOGGER.debug("SessionID = {}", (Object)this.sessionId);
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadExecutor();
            }
            this.setLeader(this.keyValueClient.acquireLock(this.servicePath, this.sessionId));
            this.executorService.submit(new Watcher());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.sessionId != null) {
            this.sessionClient.destroySession(this.sessionId);
            this.sessionId = null;
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService.awaitTermination(this.ttl / 3, TimeUnit.SECONDS);
            }
        }
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.debug("Leadership taken ({}, {})", (Object)this.serviceName, (Object)this.sessionId);
            this.startAllStoppedConsumers();
        } else if (!this.leader.getAndSet(isLeader) && isLeader) {
            LOGGER.debug("Leadership lost ({}, {})", (Object)this.serviceName, (Object)this.sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.suspendedRoutes.contains(route)) {
                    this.startConsumer(route.getConsumer());
                    this.suspendedRoutes.remove(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConsumer(Route route) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.suspendedRoutes.contains(route)) {
                    LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.stopConsumer(route.getConsumer());
                    this.suspendedRoutes.add(route);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllStoppedConsumers() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Route route : this.suspendedRoutes) {
                    LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                    this.startConsumer(route.getConsumer());
                }
                this.suspendedRoutes.clear();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public Consul getConsul() {
        return this.consul;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.servicePath = String.format("/service/%s/leader", serviceName);
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl > 10 ? ttl : 10;
    }

    public int getLockDelay() {
        return this.lockDelay;
    }

    public void setLockDelay(int lockDelay) {
        this.lockDelay = lockDelay > 10 ? lockDelay : 10;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    private class Watcher
    implements Runnable,
    ConsulResponseCallback<Optional<Value>> {
        private Watcher() {
        }

        public void onComplete(ConsulResponse<Optional<Value>> consulResponse) {
            if (ConsulRoutePolicy.this.isRunAllowed()) {
                Value response = (Value)((Optional)consulResponse.getResponse()).orNull();
                if (response != null) {
                    String sid = (String)response.getSession().orNull();
                    if (ObjectHelper.isEmpty((Object)sid)) {
                        LOGGER.debug("Try to take leadership ...");
                        ConsulRoutePolicy.this.setLeader(ConsulRoutePolicy.this.keyValueClient.acquireLock(ConsulRoutePolicy.this.servicePath, ConsulRoutePolicy.this.sessionId));
                    } else if (!ConsulRoutePolicy.this.sessionId.equals(sid) && ConsulRoutePolicy.this.leader.get()) {
                        ConsulRoutePolicy.this.setLeader(false);
                    }
                }
                ConsulRoutePolicy.this.index.set(consulResponse.getIndex());
                this.run();
            }
        }

        public void onFailure(Throwable throwable) {
            ConsulRoutePolicy.this.handleException(throwable);
        }

        @Override
        public void run() {
            if (ConsulRoutePolicy.this.isRunAllowed()) {
                ConsulRoutePolicy.this.sessionClient.renewSession(ConsulRoutePolicy.this.sessionId);
                ConsulRoutePolicy.this.keyValueClient.getValue(ConsulRoutePolicy.this.servicePath, (QueryOptions)QueryOptions.blockSeconds((int)(ConsulRoutePolicy.this.ttl / 3), (BigInteger)((BigInteger)ConsulRoutePolicy.this.index.get())).build(), (ConsulResponseCallback)this);
            }
        }
    }
}

