/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.model.session.ImmutableSession;
import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.model.session.SessionCreatedResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.SerializationUtils;

public class ConsulRegistry
implements Registry {
    private String hostname = "localhost";
    private int port = 8500;
    private Consul consul;
    private KeyValueClient kvClient;

    public ConsulRegistry(String hostname) {
        this(hostname, 8500);
    }

    public ConsulRegistry(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        HostAndPort hostAndPort = HostAndPort.fromParts((String)hostname, (int)port);
        this.consul = Consul.builder().withHostAndPort(hostAndPort).build();
    }

    private ConsulRegistry(Builder builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
        HostAndPort hostAndPort = HostAndPort.fromParts((String)this.hostname, (int)this.port);
        this.consul = Consul.builder().withHostAndPort(hostAndPort).build();
    }

    public Object lookupByName(String key) {
        key = key.replaceAll("\\$", "/");
        this.kvClient = this.consul.keyValueClient();
        Optional result = this.kvClient.getValueAsString(key);
        if (result.isPresent()) {
            byte[] postDecodedValue = Base64.decodeBase64((String)((String)result.get()));
            return SerializationUtils.deserialize((byte[])postDecodedValue);
        }
        return null;
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object object = this.lookupByName(name);
        if (object == null) {
            return null;
        }
        try {
            return type.cast(object);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in Consul Registry: " + this + " of type: " + object.getClass().getName() + "expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        List keys;
        Object obj = null;
        HashMap<String, T> result = new HashMap<String, T>();
        String keyPrefix = type.getName().replaceAll("\\$", "/");
        this.kvClient = this.consul.keyValueClient();
        try {
            keys = this.kvClient.getKeys(keyPrefix);
        }
        catch (ConsulException e) {
            return result;
        }
        if (keys != null) {
            for (String key : keys) {
                obj = this.lookupByName((key = key.substring(key.lastIndexOf(47) + 1)).replaceAll("\\$", "/"));
                if (!type.isInstance(obj)) continue;
                result.put(key, type.cast(obj));
            }
        }
        return result;
    }

    public <T> Set<T> findByType(Class<T> type) {
        String keyPrefix = type.getName().replaceAll("\\$", "/");
        Object object = null;
        HashSet<T> result = new HashSet<T>();
        List keys = null;
        try {
            keys = this.kvClient.getKeys(keyPrefix);
        }
        catch (ConsulException e) {
            return result;
        }
        if (keys != null) {
            for (String key : keys) {
                object = this.lookupByName((key = key.substring(key.lastIndexOf(47) + 1)).replaceAll("\\$", "/"));
                if (!type.isInstance(object)) continue;
                result.add(type.cast(object));
            }
        }
        return result;
    }

    public void remove(String key) {
        SessionClient sessionClient = this.consul.sessionClient();
        String sessionName = "session_" + UUID.randomUUID().toString();
        SessionCreatedResponse response = sessionClient.createSession((Session)ImmutableSession.builder().name(sessionName).build());
        String sessionId = response.getId();
        this.kvClient = this.consul.keyValueClient();
        String lockKey = "lock_" + key;
        this.kvClient.acquireLock(lockKey, sessionName, sessionId);
        Object object = this.lookupByName(key);
        if (object == null) {
            String msg = "Bean with key '" + key + "' did not exist in Consul Registry.";
            throw new NoSuchBeanException(msg);
        }
        this.kvClient.deleteKey(key);
        this.kvClient.deleteKey(object.getClass().getName() + "/" + key);
        this.kvClient.releaseLock(lockKey, sessionId);
    }

    public void put(String key, Object object) {
        key = key.replaceAll("\\$", "/");
        SessionClient sessionClient = this.consul.sessionClient();
        String sessionName = "session_" + UUID.randomUUID().toString();
        SessionCreatedResponse response = sessionClient.createSession((Session)ImmutableSession.builder().name(sessionName).build());
        String sessionId = response.getId();
        this.kvClient = this.consul.keyValueClient();
        String lockKey = "lock_" + key;
        this.kvClient.acquireLock(lockKey, sessionName, sessionId);
        if (this.lookupByName(key) != null) {
            this.remove(key);
        }
        Object clone = SerializationUtils.clone((Serializable)((Serializable)object));
        byte[] serializedObject = SerializationUtils.serialize((Serializable)((Serializable)clone));
        byte[] preEncodedValue = Base64.encodeBase64((byte[])serializedObject);
        String value = new String(preEncodedValue);
        this.kvClient.putValue(key, value);
        this.kvClient.putValue(object.getClass().getName().replaceAll("\\$", "/") + "/" + key, "1");
        this.kvClient.releaseLock(lockKey, sessionId);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.lookupByType(type);
    }

    public static class Builder {
        String hostname;
        Integer port = 8500;

        public Builder(String hostname) {
            this.hostname = hostname;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public ConsulRegistry build() {
            return new ConsulRegistry(this);
        }
    }
}

