/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.cloud;

import com.orbitz.consul.Consul;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.option.ImmutableQueryOptions;
import com.orbitz.consul.option.QueryOptions;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceHealth;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceHealth;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;

public final class ConsulServiceDiscovery
extends DefaultServiceDiscovery {
    private final Supplier<Consul> client = Suppliers.memorize(configuration::createConsulClient, this::rethrowAsRuntimeCamelException);
    private final QueryOptions queryOptions;

    public ConsulServiceDiscovery(ConsulConfiguration configuration) throws Exception {
        ImmutableQueryOptions.Builder builder = ImmutableQueryOptions.builder();
        ObjectHelper.ifNotEmpty((Object)configuration.getDatacenter(), arg_0 -> ((ImmutableQueryOptions.Builder)builder).datacenter(arg_0));
        ObjectHelper.ifNotEmpty(configuration.getTags(), arg_0 -> ((ImmutableQueryOptions.Builder)builder).tag(arg_0));
        this.queryOptions = builder.build();
    }

    public List<ServiceDefinition> getServices(String name) {
        List services = (List)this.client.get().catalogClient().getService(name, this.queryOptions).getResponse();
        List healths = (List)this.client.get().healthClient().getAllServiceInstances(name, this.queryOptions).getResponse();
        return services.stream().map(service -> this.newService(name, (CatalogService)service, healths)).collect(Collectors.toList());
    }

    private void rethrowAsRuntimeCamelException(Exception e) {
        throw new RuntimeCamelException((Throwable)e);
    }

    private boolean isHealthy(com.orbitz.consul.model.health.ServiceHealth serviceHealth) {
        return serviceHealth.getChecks().stream().allMatch(check -> ObjectHelper.equal((Object)check.getStatus(), (Object)"passing", (boolean)true));
    }

    private ServiceDefinition newService(String serviceName, CatalogService service, List<com.orbitz.consul.model.health.ServiceHealth> serviceHealthList) {
        HashMap<String, String> meta = new HashMap<String, String>();
        ObjectHelper.ifNotEmpty((Object)service.getServiceId(), val -> meta.put("service_id", (String)val));
        ObjectHelper.ifNotEmpty((Object)service.getNode(), val -> meta.put("node", (String)val));
        ObjectHelper.ifNotEmpty((Object)service.getServiceName(), val -> meta.put("service_name", (String)val));
        List tags = service.getServiceTags();
        if (tags != null) {
            for (String tag : service.getServiceTags()) {
                String[] items = tag.split("=");
                if (items.length == 1) {
                    meta.put(items[0], items[0]);
                    continue;
                }
                if (items.length != 2) continue;
                meta.put(items[0], items[1]);
            }
        }
        return new DefaultServiceDefinition(serviceName, service.getServiceAddress(), service.getServicePort(), meta, (ServiceHealth)new DefaultServiceHealth(serviceHealthList.stream().allMatch(this::isHealthy)));
    }
}

