/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.enpoint;

import com.orbitz.consul.Consul;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.model.session.Session;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.enpoint.AbstractConsulProducer;
import org.apache.camel.util.ObjectHelper;

public final class ConsulSessionProducer
extends AbstractConsulProducer<SessionClient> {
    public ConsulSessionProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::sessionClient);
    }

    @InvokeOnHeader(value="CREATE")
    protected void create(Message message) throws Exception {
        this.setBodyAndResult(message, ((SessionClient)this.getClient()).createSession((Session)message.getMandatoryBody(Session.class), (String)message.getHeader("CamelConsulDatacenter", String.class)));
    }

    @InvokeOnHeader(value="DESTROY")
    protected void destroy(Message message) throws Exception {
        String sessionId = (String)message.getHeader("CamelConsulSession", String.class);
        if (ObjectHelper.isEmpty((Object)sessionId)) {
            ((SessionClient)this.getClient()).destroySession((String)message.getMandatoryBody(String.class), (String)message.getHeader("CamelConsulDatacenter", String.class));
        } else {
            ((SessionClient)this.getClient()).destroySession(sessionId, (String)message.getHeader("CamelConsulDatacenter", String.class));
        }
        this.setBodyAndResult(message, null, true);
    }

    @InvokeOnHeader(value="INFO")
    protected void info(Message message) throws Exception {
        String sessionId = (String)message.getHeader("CamelConsulSession", String.class);
        if (ObjectHelper.isEmpty((Object)sessionId)) {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).getSessionInfo((String)message.getMandatoryBody(String.class), (String)message.getHeader("CamelConsulDatacenter", String.class)).orNull());
        } else {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).getSessionInfo(sessionId, (String)message.getHeader("CamelConsulDatacenter", String.class)).orNull());
        }
    }

    @InvokeOnHeader(value="LIST")
    protected void list(Message message) throws Exception {
        this.setBodyAndResult(message, ((SessionClient)this.getClient()).listSessions((String)message.getHeader("CamelConsulDatacenter", String.class)));
    }

    @InvokeOnHeader(value="RENEW")
    protected void renew(Message message) throws Exception {
        String sessionId = (String)message.getHeader("CamelConsulSession", String.class);
        if (ObjectHelper.isEmpty((Object)sessionId)) {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).renewSession((String)message.getHeader("CamelConsulDatacenter", String.class), (String)message.getMandatoryBody(String.class)));
        } else {
            this.setBodyAndResult(message, ((SessionClient)this.getClient()).renewSession((String)message.getHeader("CamelConsulDatacenter", String.class), sessionId));
        }
    }
}

