/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.enpoint.ConsulAgentProducer;
import org.apache.camel.component.consul.enpoint.ConsulCatalogProducer;
import org.apache.camel.component.consul.enpoint.ConsulCoordinatesProducer;
import org.apache.camel.component.consul.enpoint.ConsulEventConsumer;
import org.apache.camel.component.consul.enpoint.ConsulEventProducer;
import org.apache.camel.component.consul.enpoint.ConsulHealthProducer;
import org.apache.camel.component.consul.enpoint.ConsulKeyValueConsumer;
import org.apache.camel.component.consul.enpoint.ConsulKeyValueProducer;
import org.apache.camel.component.consul.enpoint.ConsulPreparedQueryProducer;
import org.apache.camel.component.consul.enpoint.ConsulSessionProducer;
import org.apache.camel.component.consul.enpoint.ConsulStatusProducer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.jsse.SSLContextParameters;

public class ConsulComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private ConsulConfiguration configuration = new ConsulConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public ConsulComponent() {
    }

    public ConsulComponent(CamelContext context) {
        super(context);
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public void setUrl(String url) {
        this.configuration.setUrl(url);
    }

    public String getDatacenter() {
        return this.configuration.getDatacenter();
    }

    public void setDatacenter(String datacenter) {
        this.configuration.setDatacenter(datacenter);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getAclToken() {
        return this.configuration.getAclToken();
    }

    public void setAclToken(String aclToken) {
        this.configuration.setAclToken(aclToken);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public ConsulConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConsulConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ConsulConfiguration configuration = Optional.ofNullable(this.configuration).orElseGet(ConsulConfiguration::new).copy();
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        this.setProperties(configuration, parameters);
        switch (remaining) {
            case "kv": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulKeyValueProducer::new), Optional.of(ConsulKeyValueConsumer::new));
            }
            case "event": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulEventProducer::new), Optional.of(ConsulEventConsumer::new));
            }
            case "agent": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulAgentProducer::new), Optional.empty());
            }
            case "coordinates": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulCoordinatesProducer::new), Optional.empty());
            }
            case "health": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulHealthProducer::new), Optional.empty());
            }
            case "status": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulStatusProducer::new), Optional.empty());
            }
            case "preparedQuery": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulPreparedQueryProducer::new), Optional.empty());
            }
            case "catalog": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulCatalogProducer::new), Optional.empty());
            }
            case "session": {
                return new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulSessionProducer::new), Optional.empty());
            }
        }
        throw new IllegalArgumentException("Unknown apiEndpoint: " + remaining);
    }
}

