/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.enpoint;

import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.option.PutOptions;
import com.orbitz.consul.option.QueryOptions;
import java.util.List;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.enpoint.AbstractConsulProducer;

public final class ConsulKeyValueProducer
extends AbstractConsulProducer<KeyValueClient> {
    public ConsulKeyValueProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::keyValueClient);
    }

    @InvokeOnHeader(value="PUT")
    protected void put(Message message) throws Exception {
        message.setHeader("CamelConsulResult", (Object)((KeyValueClient)this.getClient()).putValue(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), (String)message.getBody(String.class), ((Long)message.getHeader("CamelConsulFlags", (Object)0L, Long.class)).longValue(), (PutOptions)message.getHeader("CamelConsulOptions", (Object)PutOptions.BLANK, PutOptions.class)));
    }

    @InvokeOnHeader(value="GET_VALUE")
    protected void getValue(Message message) throws Exception {
        Boolean asString = (Boolean)message.getHeader("CamelConsulValueAsString", (Object)this.getConfiguration().isValueAsString(), Boolean.class);
        Object result = asString != false ? ((KeyValueClient)this.getClient()).getValueAsString(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)).orNull() : ((KeyValueClient)this.getClient()).getValue(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), (QueryOptions)message.getHeader("CamelConsulOptions", (Object)QueryOptions.BLANK, QueryOptions.class)).orNull();
        this.setBodyAndResult(message, result);
    }

    @InvokeOnHeader(value="GET_VALUES")
    protected void getValues(Message message) throws Exception {
        Boolean asString = (Boolean)message.getHeader("CamelConsulValueAsString", (Object)this.getConfiguration().isValueAsString(), Boolean.class);
        List result = asString != false ? ((KeyValueClient)this.getClient()).getValuesAsString(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)) : ((KeyValueClient)this.getClient()).getValues(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), (QueryOptions)message.getHeader("CamelConsulOptions", (Object)QueryOptions.BLANK, QueryOptions.class));
        this.setBodyAndResult(message, result);
    }

    @InvokeOnHeader(value="GET_KEYS")
    protected void getKeys(Message message) throws Exception {
        this.setBodyAndResult(message, ((KeyValueClient)this.getClient()).getKeys(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)));
    }

    @InvokeOnHeader(value="GET_SESSIONS")
    protected void getSessions(Message message) throws Exception {
        this.setBodyAndResult(message, ((KeyValueClient)this.getClient()).getSession(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class)));
    }

    @InvokeOnHeader(value="DELETE_KEY")
    protected void deleteKey(Message message) throws Exception {
        ((KeyValueClient)this.getClient()).deleteKey(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class));
        message.setHeader("CamelConsulResult", (Object)true);
    }

    @InvokeOnHeader(value="DELETE_KEYS")
    protected void deleteKeys(Message message) throws Exception {
        ((KeyValueClient)this.getClient()).deleteKeys(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class));
        message.setHeader("CamelConsulResult", (Object)true);
    }

    @InvokeOnHeader(value="LOCK")
    protected void lock(Message message) throws Exception {
        message.setHeader("CamelConsulResult", (Object)((KeyValueClient)this.getClient()).acquireLock(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), (String)message.getBody(String.class), (String)message.getHeader("CamelConsulSession", (Object)"", String.class)));
    }

    @InvokeOnHeader(value="UNLOCK")
    protected void unlock(Message message) throws Exception {
        message.setHeader("CamelConsulResult", (Object)((KeyValueClient)this.getClient()).releaseLock(this.getMandatoryHeader(message, "CamelConsulKey", this.getConfiguration().getKey(), String.class), this.getMandatoryHeader(message, "CamelConsulSession", String.class)));
    }
}

