/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContextComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(LocalContextComponent.class);
    private CamelContext localCamelContext;
    private List<String> localProtocolSchemes = new ArrayList<String>(Arrays.asList("direct", "seda", "mock"));

    public LocalContextComponent(CamelContext localCamelContext) {
        ObjectHelper.notNull((Object)localCamelContext, (String)"localCamelContext");
        this.localCamelContext = localCamelContext;
    }

    public List<String> getLocalProtocolSchemes() {
        return this.localProtocolSchemes;
    }

    public void setLocalProtocolSchemes(List<String> localProtocolSchemes) {
        this.localProtocolSchemes = localProtocolSchemes;
    }

    public CamelContext getLocalCamelContext() {
        return this.localCamelContext;
    }

    public void setLocalCamelContext(CamelContext localCamelContext) {
        this.localCamelContext = localCamelContext;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Endpoint endpoint;
        Map map = this.getLocalCamelContext().getEndpointMap();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Trying to lookup " + remaining + " in local map " + map.keySet());
        }
        if ((endpoint = (Endpoint)map.get(remaining)) != null) {
            this.logUsingEndpoint(uri, endpoint);
            return endpoint;
        }
        String[] separators = new String[]{":", "://"};
        for (String scheme : this.localProtocolSchemes) {
            for (String separator : separators) {
                String newUri = scheme + separator + remaining;
                endpoint = (Endpoint)map.get(newUri);
                if (endpoint == null) continue;
                this.logUsingEndpoint(uri, endpoint);
                return endpoint;
            }
        }
        return null;
    }

    protected void logUsingEndpoint(String uri, Endpoint endpoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping the URI: " + uri + " to local endpoint: " + endpoint);
        }
    }
}

