/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.context;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QualifiedContextComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(QualifiedContextComponent.class);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] splitURI = ObjectHelper.splitOnCharacter((String)remaining, (String)":", (int)2);
        if (splitURI[1] != null) {
            String contextId = splitURI[0];
            String localEndpoint = splitURI[1];
            Component component = this.getCamelContext().getComponent(contextId);
            if (component != null) {
                LOG.debug("Attempting to create local endpoint: {} inside the component: {}", (Object)localEndpoint, (Object)component);
                return component.createEndpoint(localEndpoint);
            }
        }
        return null;
    }
}

