/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.view.ViewOptions;
import com.couchbase.client.java.view.ViewOrdering;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.couchbase.CouchbaseEndpoint;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseConsumer
extends DefaultScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConsumer.class);
    private final CouchbaseEndpoint endpoint;
    private final Bucket bucket;
    private ViewOptions viewOptions;
    private Collection collection;

    public CouchbaseConsumer(CouchbaseEndpoint endpoint, Bucket client, Processor processor) {
        super((DefaultEndpoint)endpoint, processor);
        this.bucket = client;
        this.endpoint = endpoint;
        Scope scope = endpoint.getScope() != null ? client.scope(endpoint.getScope()) : client.defaultScope();
        this.collection = endpoint.getCollection() != null ? scope.collection(endpoint.getCollection()) : client.defaultCollection();
        this.init();
    }

    protected void doInit() {
        int skip;
        this.viewOptions = ViewOptions.viewOptions();
        int limit = this.endpoint.getLimit();
        if (limit > 0) {
            this.viewOptions.limit(limit);
        }
        if ((skip = this.endpoint.getSkip()) > 0) {
            this.viewOptions.skip(skip);
        }
        if (this.endpoint.isDescending()) {
            this.viewOptions.order(ViewOrdering.DESCENDING);
        }
        String rangeStartKey = this.endpoint.getRangeStartKey();
        String rangeEndKey = this.endpoint.getRangeEndKey();
        if ("".equals(rangeStartKey) || "".equals(rangeEndKey)) {
            return;
        }
        this.viewOptions.startKey(rangeEndKey).endKey(rangeEndKey);
    }

    protected void doStart() throws Exception {
        LOG.info("Starting Couchbase consumer");
        super.doStart();
    }

    protected void doStop() throws Exception {
        LOG.info("Stopping Couchbase consumer");
        super.doStop();
        if (this.bucket != null) {
            this.bucket.core().shutdown();
        }
    }

    protected synchronized int poll() throws Exception {
        ViewResult result = this.bucket.viewQuery(this.endpoint.getDesignDocumentName(), this.endpoint.getViewName(), this.viewOptions);
        LOG.info("Received result set from Couchbase");
        Collection collection = this.bucket.defaultCollection();
        if (LOG.isTraceEnabled()) {
            LOG.trace("ViewResponse =  {}", (Object)result);
        }
        String consumerProcessedStrategy = this.endpoint.getConsumerProcessedStrategy();
        for (ViewRow row : result.rows()) {
            String id = (String)row.id().get();
            GetResult doc = collection.get(id);
            String key = (String)((List)row.keyAs(List.class).get()).get(0);
            String designDocumentName = this.endpoint.getDesignDocumentName();
            String viewName = this.endpoint.getViewName();
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setBody((Object)doc);
            exchange.getIn().setHeader("CCB_ID", (Object)id);
            exchange.getIn().setHeader("CCB_KEY", (Object)key);
            exchange.getIn().setHeader("CCB_DDN", (Object)designDocumentName);
            exchange.getIn().setHeader("CCB_VN", (Object)viewName);
            if ("delete".equalsIgnoreCase(consumerProcessedStrategy)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Deleting doc with ID {}", (Object)id);
                }
                collection.remove(id);
            } else if ("filter".equalsIgnoreCase(consumerProcessedStrategy)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Filtering out ID {}", (Object)id);
                }
            } else {
                LOG.trace("No strategy set for already processed docs, beware of duplicates!");
            }
            this.logDetails(id, doc, key, designDocumentName, viewName, exchange);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)e);
            }
        }
        return result.rows().size();
    }

    private void logDetails(String id, Object doc, String key, String designDocumentName, String viewName, Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created exchange = {}", (Object)exchange);
            LOG.trace("Added Document in body = {}", doc);
            LOG.trace("Adding to Header");
            LOG.trace("ID = {}", (Object)id);
            LOG.trace("Key = {}", (Object)key);
            LOG.trace("Design Document Name = {}", (Object)designDocumentName);
            LOG.trace("View Name = {}", (Object)viewName);
        }
    }
}

