/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.couchbase.CouchbaseComponent;
import org.apache.camel.component.couchbase.CouchbaseConsumer;
import org.apache.camel.component.couchbase.CouchbaseProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="couchbase", title="Couchbase", syntax="couchbase:protocol://hostname:port", category={Category.DATABASE, Category.NOSQL})
public class CouchbaseEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required=true)
    private String protocol;
    @UriPath
    @Metadata(required=true)
    private String hostname;
    @UriPath(defaultValue="8091")
    private int port;
    @UriParam
    @Metadata(required=true)
    private String bucket;
    @UriParam
    private String collection;
    @UriParam
    private String scope;
    @UriParam
    private String key;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced")
    private String additionalHosts;
    @UriParam(label="producer", defaultValue="0")
    private int persistTo;
    @UriParam(label="producer", defaultValue="0")
    private int replicateTo;
    @UriParam(label="producer", defaultValue="CCB_PUT")
    private String operation = "CCB_PUT";
    @UriParam(label="producer", defaultValue="false")
    private boolean autoStartIdForInserts;
    @UriParam(label="producer", defaultValue="2")
    private int producerRetryAttempts = 2;
    @UriParam(label="producer", defaultValue="5000")
    private int producerRetryPause = 5000;
    @UriParam(label="producer")
    private long startingIdForInsertsFrom;
    @UriParam(label="consumer", defaultValue="beer")
    private String designDocumentName = "beer";
    @UriParam(label="consumer", defaultValue="brewery_beers")
    private String viewName = "brewery_beers";
    @UriParam(label="consumer", defaultValue="-1")
    private int limit = -1;
    @UriParam(label="consumer", defaultValue="false")
    private boolean descending;
    @UriParam(label="consumer", defaultValue="-1")
    private int skip = -1;
    @UriParam(label="consumer")
    private String rangeStartKey;
    @UriParam(label="consumer")
    private String rangeEndKey = "";
    @UriParam(label="consumer", defaultValue="false")
    private boolean fullDocument = true;
    @UriParam(label="consumer", defaultValue="none")
    private String consumerProcessedStrategy = "none";
    @UriParam(label="advanced", defaultValue="2500", javaType="java.time.Duration")
    private long queryTimeout = 2500L;
    @UriParam(label="advanced", defaultValue="2500", javaType="java.time.Duration")
    private long connectTimeout = 30000L;

    public CouchbaseEndpoint() {
    }

    public CouchbaseEndpoint(String uri, String remaining, CouchbaseComponent component) throws URISyntaxException {
        super(uri, (Component)component);
        URI remainingUri = new URI(remaining);
        this.protocol = remainingUri.getScheme();
        if (this.protocol == null) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form couchbase:http[s]://hostname[:port]?bucket=[bucket][&options...]");
        }
        this.port = remainingUri.getPort() == -1 ? 8091 : remainingUri.getPort();
        this.hostname = remainingUri.getHost();
        if (this.hostname == null) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form couchbase:http[s]://hostname[:port]?bucket=[bucket][&options...]");
        }
    }

    public CouchbaseEndpoint(String endpointUri, CouchbaseComponent component) {
        super(endpointUri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new CouchbaseProducer(this, this.createClient(), this.persistTo, this.replicateTo);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CouchbaseConsumer consumer = new CouchbaseConsumer(this, this.createClient(), processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAdditionalHosts() {
        return this.additionalHosts;
    }

    public void setAdditionalHosts(String additionalHosts) {
        this.additionalHosts = additionalHosts;
    }

    public int getPersistTo() {
        return this.persistTo;
    }

    public void setPersistTo(int persistTo) {
        this.persistTo = persistTo;
    }

    public int getReplicateTo() {
        return this.replicateTo;
    }

    public void setReplicateTo(int replicateTo) {
        this.replicateTo = replicateTo;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean isAutoStartIdForInserts() {
        return this.autoStartIdForInserts;
    }

    public void setAutoStartIdForInserts(boolean autoStartIdForInserts) {
        this.autoStartIdForInserts = autoStartIdForInserts;
    }

    public long getStartingIdForInsertsFrom() {
        return this.startingIdForInsertsFrom;
    }

    public void setStartingIdForInsertsFrom(long startingIdForInsertsFrom) {
        this.startingIdForInsertsFrom = startingIdForInsertsFrom;
    }

    public int getProducerRetryAttempts() {
        return this.producerRetryAttempts;
    }

    public void setProducerRetryAttempts(int producerRetryAttempts) {
        this.producerRetryAttempts = producerRetryAttempts;
    }

    public int getProducerRetryPause() {
        return this.producerRetryPause;
    }

    public void setProducerRetryPause(int producerRetryPause) {
        this.producerRetryPause = producerRetryPause;
    }

    public String getDesignDocumentName() {
        return this.designDocumentName;
    }

    public void setDesignDocumentName(String designDocumentName) {
        this.designDocumentName = designDocumentName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public String getRangeStartKey() {
        return this.rangeStartKey;
    }

    public void setRangeStartKey(String rangeStartKey) {
        this.rangeStartKey = rangeStartKey;
    }

    public String getRangeEndKey() {
        return this.rangeEndKey;
    }

    public void setRangeEndKey(String rangeEndKey) {
        this.rangeEndKey = rangeEndKey;
    }

    public boolean isFullDocument() {
        return this.fullDocument;
    }

    public void setFullDocument(boolean fullDocument) {
        this.fullDocument = fullDocument;
    }

    public String getConsumerProcessedStrategy() {
        return this.consumerProcessedStrategy;
    }

    public void setConsumerProcessedStrategy(String consumerProcessedStrategy) {
        this.consumerProcessedStrategy = consumerProcessedStrategy;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public URI[] makeBootstrapURI() throws URISyntaxException {
        if (this.additionalHosts == null || "".equals(this.additionalHosts)) {
            return new URI[]{new URI(this.protocol + "://" + this.hostname + ":" + this.port + "/pools")};
        }
        return this.getAllUris();
    }

    private URI[] getAllUris() throws URISyntaxException {
        String[] hosts = this.additionalHosts.split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add(this.hostname);
        hostList.addAll(Arrays.asList(hosts));
        LinkedHashSet hostSet = new LinkedHashSet(hostList);
        hosts = hostSet.toArray(new String[hostSet.size()]);
        URI[] uriArray = new URI[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            uriArray[i] = new URI(this.protocol + "://" + hosts[i] + ":" + this.port + "/pools");
        }
        return uriArray;
    }

    private Bucket createClient() throws Exception {
        List<URI> hosts = Arrays.asList(this.makeBootstrapURI());
        if (this.bucket == null || this.bucket.isEmpty()) {
            throw new CamelException("Invalid URI. Format must be of the form couchbase:http[s]://hostname[:port]?bucket=[bucket][&options...]");
        }
        ClusterEnvironment.Builder cfb = ClusterEnvironment.builder();
        if (this.queryTimeout != 2500L) {
            cfb.timeoutConfig().connectTimeout(Duration.ofMillis(this.connectTimeout)).queryTimeout(Duration.ofMillis(this.queryTimeout));
        }
        ClusterEnvironment env = cfb.build();
        String addHosts = hosts.stream().map(URI::getHost).collect(Collectors.joining(","));
        String connectionString = !addHosts.isEmpty() ? addHosts : this.hostname;
        Cluster cluster = Cluster.connect((String)connectionString, (ClusterOptions)ClusterOptions.clusterOptions((String)this.username, (String)this.password).environment(env));
        return cluster.bucket(this.bucket);
    }
}

