/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CouchbaseEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol:hostname:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "couchbase".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "hostname", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", 8091, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(48);
        props.add("backoffMultiplier");
        props.add("queryTimeout");
        props.add("consumerProcessedStrategy");
        props.add("skip");
        props.add("initialDelay");
        props.add("descending");
        props.add("scheduler");
        props.add("protocol");
        props.add("hostname");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("viewName");
        props.add("fullDocument");
        props.add("additionalHosts");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("scope");
        props.add("limit");
        props.add("connectTimeout");
        props.add("greedy");
        props.add("scheduledExecutorService");
        props.add("rangeEndKey");
        props.add("key");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("sendEmptyMessageWhenIdle");
        props.add("autoStartIdForInserts");
        props.add("persistTo");
        props.add("producerRetryPause");
        props.add("schedulerProperties");
        props.add("exchangePattern");
        props.add("rangeStartKey");
        props.add("collection");
        props.add("designDocumentName");
        props.add("startingIdForInsertsFrom");
        props.add("backoffIdleThreshold");
        props.add("replicateTo");
        props.add("bucket");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("port");
        props.add("producerRetryAttempts");
        props.add("startScheduler");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

