/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonObject;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.couchdb.CouchDbChangesetTracker;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.resume.ResumeStrategyHelper;

public class CouchDbConsumer
extends DefaultConsumer
implements ResumeAware<ResumeStrategy> {
    private final CouchDbClientWrapper couchClient;
    private final CouchDbEndpoint endpoint;
    private ExecutorService executor;
    private CouchDbChangesetTracker task;
    private ResumeStrategy resumeStrategy;

    public CouchDbConsumer(CouchDbEndpoint endpoint, CouchDbClientWrapper couchClient, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.couchClient = couchClient;
        this.endpoint = endpoint;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    public Exchange createExchange(String seq, String id, JsonObject obj, boolean deleted) {
        Exchange exchange = this.createExchange(false);
        exchange.getIn().setHeader("CouchDbDatabase", (Object)this.endpoint.getDatabase());
        exchange.getIn().setHeader("CouchDbSeq", (Object)seq);
        exchange.getIn().setHeader("CouchDbId", (Object)id);
        exchange.getIn().setHeader("CouchDbRev", (Object)obj.get("_rev").getAsString());
        exchange.getIn().setHeader("CouchDbMethod", (Object)(deleted ? "DELETE" : "UPDATE"));
        exchange.getIn().setBody((Object)obj);
        return exchange;
    }

    protected void doStart() throws Exception {
        ResumeStrategyHelper.resume((CamelContext)this.getEndpoint().getCamelContext(), (Object)((Object)this), (ResumeStrategy)this.resumeStrategy, (String)"CamelCouchDbResumeAction");
        super.doStart();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), 1);
        this.task = new CouchDbChangesetTracker(this.endpoint, this, this.couchClient);
        this.executor.submit(this.task);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.task != null) {
            this.task.stop();
        }
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }
}

