/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonObject;
import org.apache.camel.Exchange;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbConsumer;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.lightcouch.Changes;
import org.lightcouch.ChangesResult;
import org.lightcouch.CouchDbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbChangesetTracker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CouchDbChangesetTracker.class);
    private static final int MAX_DB_ERROR_REPEATS = 8;
    private volatile boolean stopped;
    private final CouchDbClientWrapper couchClient;
    private final CouchDbEndpoint endpoint;
    private final CouchDbConsumer consumer;
    private Changes changes;

    public CouchDbChangesetTracker(CouchDbEndpoint endpoint, CouchDbConsumer consumer, CouchDbClientWrapper couchClient) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.couchClient = couchClient;
        this.initChanges(null);
    }

    private void initChanges(String sequence) {
        String since = sequence;
        if (null == since) {
            since = this.couchClient.getLatestUpdateSequence();
        }
        LOG.debug("Last sequence [{}]", (Object)since);
        this.changes = this.couchClient.changes().style(this.endpoint.getStyle()).includeDocs(true).since(since).heartBeat(this.endpoint.getHeartbeat()).continuousChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        String lastSequence = null;
        try {
            while (!this.stopped) {
                try {
                    while (this.changes.hasNext()) {
                        ChangesResult.Row feed = this.changes.next();
                        if (feed.isDeleted() && !this.endpoint.isDeletes() || !feed.isDeleted() && !this.endpoint.isUpdates()) continue;
                        lastSequence = feed.getSeq();
                        JsonObject doc = feed.getDoc();
                        Exchange exchange = this.consumer.createExchange(lastSequence, feed.getId(), doc, feed.isDeleted());
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Created exchange [exchange={}, _id={}, seq={}", new Object[]{exchange, feed.getId(), lastSequence});
                        }
                        try {
                            this.consumer.getProcessor().process(exchange);
                        }
                        catch (Exception e) {
                            this.consumer.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)e);
                        }
                        finally {
                            this.consumer.releaseExchange(exchange, false);
                        }
                    }
                    this.stopped = true;
                }
                catch (CouchDbException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("CouchDb Exception encountered waiting for changes!  Attempting to recover...", (Throwable)e);
                    }
                    if (this.waitForStability(lastSequence)) continue;
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected error causing CouchDb change tracker to exit!", (Throwable)e);
        }
    }

    private boolean waitForStability(String lastSequence) {
        boolean problems = true;
        int repeatDbErrorCount = 0;
        while (problems) {
            block6: {
                if (++repeatDbErrorCount > 8) {
                    LOG.error("CouchDb change set listener fatal error!  Retry attempts exceeded, listener must exit.");
                    return false;
                }
                try {
                    Thread.sleep((int)(Math.random() * 2000.0 + 5000.0));
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("CouchDb change set listener interrupted waiting for stability!!", (Throwable)e);
                }
            }
            try {
                this.couchClient.context().serverVersion();
                this.initChanges(lastSequence);
                problems = false;
            }
            catch (Exception e) {
                LOG.debug("Failed to get CouchDb server version and/or reset change listener!  Attempt: {}", (Object)repeatDbErrorCount, (Object)e);
            }
        }
        return true;
    }

    public void stop() {
        this.changes.stop();
    }
}

