/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cron;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cron.api.CamelCronConfiguration;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.1.0", scheme="cron", title="Cron", syntax="cron:name", consumerOnly=true, label="scheduling")
public class CronEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private Endpoint delegate;
    @UriParam
    private CamelCronConfiguration configuration;

    public CronEndpoint(String endpointUri, Component component, Endpoint delegate, CamelCronConfiguration configuration) {
        super(endpointUri, component);
        this.delegate = delegate;
        this.configuration = configuration;
    }

    public Endpoint getEndpoint() {
        return this.delegate;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Consumer consumer = this.delegate.createConsumer(processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public CamelCronConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setSynchronous(boolean synchronous) {
        super.setSynchronous(synchronous);
        if (this.delegate instanceof DefaultEndpoint) {
            ((DefaultEndpoint)this.delegate).setSynchronous(synchronous);
        }
    }

    public void setBasicPropertyBinding(boolean basicPropertyBinding) {
        super.setBasicPropertyBinding(basicPropertyBinding);
        if (this.delegate instanceof DefaultEndpoint) {
            ((DefaultEndpoint)this.delegate).setBasicPropertyBinding(basicPropertyBinding);
        }
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        super.setExchangePattern(exchangePattern);
        if (this.delegate instanceof DefaultEndpoint) {
            ((DefaultEndpoint)this.delegate).setExchangePattern(exchangePattern);
        }
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        super.setExceptionHandler(exceptionHandler);
        if (this.delegate instanceof DefaultEndpoint) {
            ((DefaultEndpoint)this.delegate).setExceptionHandler(exceptionHandler);
        }
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        super.setBridgeErrorHandler(bridgeErrorHandler);
        if (this.delegate instanceof DefaultEndpoint) {
            ((DefaultEndpoint)this.delegate).setBridgeErrorHandler(bridgeErrorHandler);
        }
    }
}

