/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cron;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.cron.CronComponent;
import org.apache.camel.component.cron.api.CamelCronConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.1.0", scheme="cron", title="Cron", syntax="cron:name", consumerOnly=true, remote=false, category={Category.SCHEDULING})
public class CronEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private Endpoint delegate;
    @UriParam
    private CamelCronConfiguration configuration;

    public CronEndpoint(String endpointUri, CronComponent component, CamelCronConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.configuration = configuration;
    }

    public void setDelegate(Endpoint delegate) {
        this.delegate = delegate;
    }

    public Endpoint getEndpoint() {
        return this.delegate;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Consumer consumer = this.delegate.createConsumer(processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public CamelCronConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.delegate, (String)"delegate endpoint");
        ServiceHelper.startService((Service)this.delegate);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.delegate);
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        ServiceHelper.stopAndShutdownService((Object)this.delegate);
    }
}

