/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CryptoCmsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":cryptoOperation:name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "crypto-cms".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "cryptoOperation", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "name", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(17);
        props.add("toBase64");
        props.add("fromBase64");
        props.add("cryptoOperation");
        props.add("keyStoreParameters");
        props.add("lazyStartProducer");
        props.add("password");
        props.add("originatorInformationProvider");
        props.add("contentEncryptionAlgorithm");
        props.add("includeContent");
        props.add("keyStore");
        props.add("secretKeyLength");
        props.add("name");
        props.add("recipient");
        props.add("unprotectedAttributesGeneratorProvider");
        props.add("verifySignaturesOfAllSigners");
        props.add("signedDataHeaderBase64");
        props.add("signer");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

