/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.camel.converter.crypto.HexUtils;

public class HMACAccumulator {
    protected OutputStream outputStream;
    private CircularBuffer unprocessed;
    private byte[] calculatedMac;
    private Mac hmac;
    private int maclength;
    private byte[] appended;

    HMACAccumulator() {
    }

    public HMACAccumulator(Key key, String macAlgorithm, String cryptoProvider, int buffersize) throws Exception {
        this.hmac = cryptoProvider == null ? Mac.getInstance(macAlgorithm) : Mac.getInstance(macAlgorithm, cryptoProvider);
        SecretKeySpec hmacKey = new SecretKeySpec(key.getEncoded(), macAlgorithm);
        this.hmac.init(hmacKey);
        this.maclength = this.hmac.getMacLength();
        this.unprocessed = new CircularBuffer(buffersize + this.maclength);
    }

    public void encryptUpdate(byte[] buffer, int read) {
        this.hmac.update(buffer, 0, read);
    }

    public void decryptUpdate(byte[] buffer, int read) throws IOException {
        this.unprocessed.write(buffer, 0, read);
        int safe = this.unprocessed.availableForRead() - this.maclength;
        if (safe > 0) {
            this.unprocessed.read(buffer, 0, safe);
            this.hmac.update(buffer, 0, safe);
            if (this.outputStream != null) {
                this.outputStream.write(buffer, 0, safe);
            }
        }
    }

    public byte[] getCalculatedMac() {
        if (this.calculatedMac == null) {
            this.calculatedMac = this.hmac.doFinal();
        }
        return this.calculatedMac;
    }

    public byte[] getAppendedMac() {
        if (this.appended == null) {
            this.appended = new byte[this.maclength];
            this.unprocessed.read(this.appended, 0, this.maclength);
        }
        return this.appended;
    }

    public void validate() {
        byte[] actual = this.getCalculatedMac();
        byte[] expected = this.getAppendedMac();
        for (int x = 0; x < actual.length; ++x) {
            if (expected[x] == actual[x]) continue;
            throw new IllegalStateException("Expected mac did not match actual mac\nexpected:" + HexUtils.byteArrayToHexString(expected) + "\n     actual:" + HexUtils.byteArrayToHexString(actual));
        }
    }

    public int getMaclength() {
        return this.maclength;
    }

    public void attachStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    static class CircularBuffer {
        private byte[] buffer;
        private int write;
        private int read;
        private int available;

        public CircularBuffer(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.available = bufferSize;
        }

        public void write(byte[] data, int pos, int len) {
            if (this.available >= len) {
                if (this.write + len > this.buffer.length) {
                    int overlap = this.write + len % this.buffer.length;
                    System.arraycopy(data, 0, this.buffer, this.write, len - overlap);
                    System.arraycopy(data, len - overlap, this.buffer, 0, overlap);
                } else {
                    System.arraycopy(data, pos, this.buffer, this.write, len);
                }
                this.write = (this.write + len) % this.buffer.length;
                this.available -= len;
            }
        }

        public int read(byte[] dest, int position, int len) {
            if (dest.length - position >= len && this.buffer.length - this.available >= len) {
                int overlap = (this.read + len) % this.buffer.length;
                if (this.read > this.write) {
                    int x = this.buffer.length - this.read;
                    System.arraycopy(this.buffer, this.read, dest, position, this.buffer.length - this.read);
                    System.arraycopy(this.buffer, 0, dest, position + x, overlap);
                } else {
                    System.arraycopy(this.buffer, this.read, dest, position, len);
                }
                this.read = (this.read + len) % this.buffer.length;
                this.available += len;
                return len;
            }
            return 0;
        }

        public boolean compareTo(byte[] compare, int pos, int len) {
            boolean equal = false;
            if (len <= this.availableForRead()) {
                int x = 0;
                while (equal && x < len) {
                    equal = compare[pos + x] != this.buffer[this.read + x % this.buffer.length];
                }
            }
            return equal;
        }

        public int availableForRead() {
            return this.buffer.length - this.available;
        }

        public int availableForWrite() {
            return this.available;
        }

        public String show() {
            StringBuilder b = new StringBuilder(HexUtils.byteArrayToHexString(this.buffer)).append("\n");
            int x = this.read;
            while (--x >= 0) {
                b.append("--");
            }
            b.append("r");
            b.append("\n");
            x = this.write;
            while (--x >= 0) {
                b.append("--");
            }
            b.append("w");
            b.append("\n");
            return b.toString();
        }
    }
}

