/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cxf.common.DataFormat;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ExchangeHelper;
import org.apache.cxf.message.MessageContentsList;

@Converter(generateLoader=true)
public final class CxfConverter {
    private CxfConverter() {
    }

    @Converter
    public static MessageContentsList toMessageContentsList(Object[] array) {
        if (array != null) {
            return new MessageContentsList(array);
        }
        return new MessageContentsList();
    }

    @Converter
    public static QName toQName(String qname) {
        return QName.valueOf(qname);
    }

    @Converter
    public static Object[] toArray(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).toArray();
        }
        Object[] answer = object == null ? new Object[]{} : new Object[]{object};
        return answer;
    }

    @Converter
    public static String soapMessageToString(SOAPMessage soapMessage, Exchange exchange) throws SOAPException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)baos);
        return baos.toString(ExchangeHelper.getCharsetName((Exchange)exchange));
    }

    @Converter
    public static InputStream soapMessageToInputStream(SOAPMessage soapMessage, Exchange exchange) throws SOAPException, IOException {
        CachedOutputStream cos = new CachedOutputStream(exchange);
        soapMessage.writeTo((OutputStream)cos);
        return cos.getInputStream();
    }

    @Converter
    public static DataFormat toDataFormat(String name) {
        return DataFormat.valueOf(name.toUpperCase());
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (MessageContentsList.class.isAssignableFrom(value.getClass())) {
            MessageContentsList list = (MessageContentsList)value;
            if (list.size() > 1 && type == String.class) {
                boolean foundHolder = false;
                for (Object embedded : list) {
                    if (embedded == null || !embedded.getClass().getName().equals("javax.xml.ws.Holder")) continue;
                    foundHolder = true;
                    break;
                }
                if (!foundHolder) {
                    return null;
                }
            }
            for (Object embedded : list) {
                if (embedded == null) continue;
                if (type.isInstance(embedded)) {
                    return type.cast(embedded);
                }
                TypeConverter tc = registry.lookup(type, embedded.getClass());
                if (tc == null) {
                    Class<?> clazz;
                    Class<?>[] classArray = embedded.getClass().getInterfaces();
                    int n = classArray.length;
                    for (int i = 0; i < n && (tc = registry.lookup(type, clazz = classArray[i])) == null; ++i) {
                    }
                }
                if (tc == null) continue;
                Object result = tc.convertTo(type, exchange, embedded);
                if (result == null) break;
                return (T)result;
            }
            return (T)TypeConverter.MISS_VALUE;
        }
        return null;
    }
}

