/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceProvider;
import java.lang.annotation.Annotation;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CxfEndpointUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CxfEndpointUtils.class);

    private CxfEndpointUtils() {
    }

    public static QName getQName(String name) {
        QName qName = null;
        if (name != null) {
            try {
                qName = QName.valueOf(name);
            }
            catch (Exception ex) {
                LOG.warn("Cannot create QName: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        return qName;
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        return CxfEndpointUtils.hasAnnotation(cls, WebService.class) || CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class);
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls == null || cls == Object.class) {
            return false;
        }
        if (null != cls.getAnnotation(annotation)) {
            return true;
        }
        for (Class<?> interfaceClass : cls.getInterfaces()) {
            if (null == interfaceClass.getAnnotation(annotation)) continue;
            return true;
        }
        return CxfEndpointUtils.hasAnnotation(cls.getSuperclass(), annotation);
    }

    public static void checkServiceClassName(String className) throws CamelException {
        if (ObjectHelper.isEmpty((String)className)) {
            throw new CamelException("serviceClass is required for CXF endpoint configuration");
        }
    }

    public static String getEffectiveAddress(Exchange exchange, String defaultAddress) {
        String retval = (String)exchange.getIn().getHeader("CamelDestinationOverrideUrl", String.class);
        if (retval == null) {
            retval = defaultAddress;
        } else {
            LOG.trace("Client address is overridden by header '{}' to value '{}'", (Object)"CamelDestinationOverrideUrl", (Object)retval);
        }
        return retval;
    }

    public static Bus createBus(CamelContext context) {
        BusFactory busFactory = BusFactory.newInstance();
        return busFactory.createBus();
    }
}

