/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import jakarta.xml.ws.WebFault;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.cxf.common.CxfBinding;
import org.apache.camel.component.cxf.common.DataFormat;
import org.apache.camel.component.cxf.common.UnitOfWorkCloserInterceptor;
import org.apache.camel.component.cxf.jaxws.CxfEndpoint;
import org.apache.camel.component.cxf.jaxws.DefaultCxfBinding;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CxfConsumer
extends DefaultConsumer
implements Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(CxfConsumer.class);
    private Server server;
    private CxfEndpoint cxfEndpoint;

    public CxfConsumer(CxfEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.cxfEndpoint = endpoint;
    }

    protected Server createServer() throws Exception {
        ServerFactoryBean svrBean = this.cxfEndpoint.createServerFactoryBean();
        svrBean.setInvoker((Invoker)new CxfConsumerInvoker(this.cxfEndpoint));
        Server ret = svrBean.create();
        if (this.cxfEndpoint.getCxfConfigurer() != null) {
            this.cxfEndpoint.getCxfConfigurer().configureServer(ret);
        }
        ret.getEndpoint().getEndpointInfo().setProperty("serviceClass", this.cxfEndpoint.getServiceClass());
        if (ObjectHelper.isNotEmpty((String)this.cxfEndpoint.getPublishedEndpointUrl())) {
            ret.getEndpoint().getEndpointInfo().setProperty("publishedEndpointUrl", (Object)this.cxfEndpoint.getPublishedEndpointUrl());
        }
        MessageObserver originalOutFaultObserver = ret.getEndpoint().getOutFaultObserver();
        ret.getEndpoint().setOutFaultObserver(message -> originalOutFaultObserver.onMessage(message));
        ret.getEndpoint().getInInterceptors().add(new UnitOfWorkCloserInterceptor("post-invoke", true));
        ret.getEndpoint().getOutInterceptors().add(new UnitOfWorkCloserInterceptor());
        return ret;
    }

    public Server getServer() {
        return this.server;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.server == null) {
            this.server = this.createServer();
        }
        this.server.start();
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
        super.doStop();
    }

    private EndpointReferenceType getReplyTo(Object o) {
        try {
            return (EndpointReferenceType)o.getClass().getMethod("getReplyTo", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Exception t) {
            throw new Fault((Throwable)t);
        }
    }

    protected boolean isAsyncInvocationSupported(org.apache.cxf.message.Exchange cxfExchange) {
        Message cxfMessage = cxfExchange.getInMessage();
        Object addressingProperties = cxfMessage.get((Object)"jakarta.xml.ws.addressing.context.inbound");
        return addressingProperties == null || ContextUtils.isGenericAddress((EndpointReferenceType)this.getReplyTo(addressingProperties));
    }

    private class CxfConsumerInvoker
    implements Invoker {
        private final CxfEndpoint endpoint;

        CxfConsumerInvoker(CxfEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public Object invoke(org.apache.cxf.message.Exchange cxfExchange, Object o) {
            Continuation continuation;
            LOG.trace("Received CXF Request: {}", (Object)cxfExchange);
            if (!this.endpoint.isSynchronous() && CxfConsumer.this.isAsyncInvocationSupported(cxfExchange) && (continuation = this.getContinuation(cxfExchange)) != null) {
                LOG.trace("Calling the Camel async processors.");
                return this.asyncInvoke(cxfExchange, continuation);
            }
            LOG.trace("Calling the Camel sync processors.");
            return this.syncInvoke(cxfExchange);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object asyncInvoke(org.apache.cxf.message.Exchange cxfExchange, final Continuation continuation) {
            LOG.trace("asyncInvoke continuation: {}", (Object)continuation);
            Continuation continuation2 = continuation;
            synchronized (continuation2) {
                if (continuation.isNew()) {
                    final Exchange camelExchange = this.prepareCamelExchange(cxfExchange);
                    LOG.trace("Suspending continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                    continuation.suspend(CxfConsumer.this.cxfEndpoint.getContinuationTimeout());
                    continuation.setObject((Object)camelExchange);
                    CxfConsumer.this.getAsyncProcessor().process(camelExchange, new AsyncCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void done(boolean doneSync) {
                            Continuation continuation2 = continuation;
                            synchronized (continuation2) {
                                LOG.trace("Resuming continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                                continuation.resume();
                            }
                        }
                    });
                } else {
                    if (!continuation.isTimeout() && continuation.isResumed()) {
                        Exchange camelExchange = (Exchange)continuation.getObject();
                        try {
                            this.setResponseBack(cxfExchange, camelExchange);
                        }
                        catch (Exception ex) {
                            CxfConsumer.this.doneUoW(camelExchange);
                            throw ex;
                        }
                    }
                    if (continuation.isTimeout() || !continuation.isResumed() && !continuation.isPending()) {
                        Exchange camelExchange = (Exchange)continuation.getObject();
                        try {
                            if (!continuation.isPending()) {
                                camelExchange.setException((Throwable)new ExchangeTimedOutException(camelExchange, CxfConsumer.this.cxfEndpoint.getContinuationTimeout()));
                            }
                            this.setResponseBack(cxfExchange, camelExchange);
                        }
                        catch (Exception ex) {
                            CxfConsumer.this.doneUoW(camelExchange);
                            throw ex;
                        }
                    }
                }
            }
            return null;
        }

        private Continuation getContinuation(org.apache.cxf.message.Exchange cxfExchange) {
            Continuation continuation;
            ContinuationProvider provider = (ContinuationProvider)cxfExchange.getInMessage().get((Object)ContinuationProvider.class.getName());
            Continuation continuation2 = continuation = provider == null ? null : provider.getContinuation();
            if (continuation != null && continuation.getClass().getName().equals("org.apache.cxf.transport.jms.continuations.JMSContinuation")) {
                return null;
            }
            return continuation;
        }

        private Object syncInvoke(org.apache.cxf.message.Exchange cxfExchange) {
            Exchange camelExchange = this.prepareCamelExchange(cxfExchange);
            try {
                try {
                    LOG.trace("Processing +++ START +++");
                    CxfConsumer.this.getProcessor().process(camelExchange);
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
                LOG.trace("Processing +++ END +++");
                this.setResponseBack(cxfExchange, camelExchange);
            }
            catch (Exception ex) {
                CxfConsumer.this.doneUoW(camelExchange);
                throw ex;
            }
            return null;
        }

        private Exchange prepareCamelExchange(org.apache.cxf.message.Exchange cxfExchange) {
            CxfEndpoint endpoint = (CxfEndpoint)CxfConsumer.this.getEndpoint();
            CxfBinding binding = endpoint.getCxfBinding();
            Exchange camelExchange = endpoint.createExchange();
            cxfExchange.put(Exchange.class, (Object)camelExchange);
            DataFormat dataFormat = endpoint.getDataFormat();
            BindingOperationInfo boi = cxfExchange.getBindingOperationInfo();
            if (boi != null && dataFormat == DataFormat.PAYLOAD && boi.isUnwrapped()) {
                boi = boi.getWrappedOperation();
                cxfExchange.put(BindingOperationInfo.class, (Object)boi);
            }
            if (boi != null) {
                camelExchange.setProperty(BindingOperationInfo.class.getName(), (Object)boi);
                LOG.trace("Set exchange property: BindingOperationInfo: {}", (Object)boi);
                if (boi.getOperationInfo().isOneWay()) {
                    camelExchange.setPattern(ExchangePattern.InOnly);
                }
            } else if (CxfConsumer.this.cxfEndpoint.getExchangePattern().equals((Object)ExchangePattern.InOnly)) {
                camelExchange.setPattern(ExchangePattern.InOnly);
            }
            camelExchange.setProperty("CamelCXFDataFormat", (Object)dataFormat);
            LOG.trace("Set Exchange property: {}={}", (Object)DataFormat.class.getName(), (Object)dataFormat);
            camelExchange.setProperty("mtom-enabled", (Object)String.valueOf(endpoint.isMtomEnabled()));
            if (endpoint.isMergeProtocolHeaders()) {
                camelExchange.setProperty("CamelCxfProtocolHeadersMerged", (Object)Boolean.TRUE);
            }
            binding.populateExchangeFromCxfRequest(cxfExchange, camelExchange);
            HashMap context = new HashMap();
            binding.extractJaxWsContext(cxfExchange, context);
            camelExchange.setProperty("jaxwsContext", context);
            try {
                CxfConsumer.this.createUoW(camelExchange);
            }
            catch (Exception e) {
                LOG.error("Error processing request", (Throwable)e);
                throw new Fault((Throwable)e);
            }
            return camelExchange;
        }

        private void setResponseBack(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) {
            CxfEndpoint endpoint = (CxfEndpoint)CxfConsumer.this.getEndpoint();
            CxfBinding binding = endpoint.getCxfBinding();
            ((DefaultCxfBinding)binding).populateCxfHeaderFromCamelExchangeBeforeCheckError(camelExchange, cxfExchange);
            this.checkFailure(camelExchange, cxfExchange);
            binding.populateCxfResponseFromExchange(camelExchange, cxfExchange);
            this.checkFailure(camelExchange, cxfExchange);
            binding.copyJaxWsContext(cxfExchange, (Map)camelExchange.getProperty("jaxwsContext"));
        }

        private void checkFailure(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Fault {
            Object body;
            Throwable t = camelExchange.getException();
            if (t == null && (body = camelExchange.getMessage().getBody()) instanceof Throwable) {
                t = (Throwable)body;
            }
            if (t != null) {
                cxfExchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                if (t instanceof Fault) {
                    cxfExchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
                    throw (Fault)t;
                }
                Fault fault = new Fault(t);
                if (fault.getMessage() == null) {
                    fault.setMessage(t.getClass().getSimpleName());
                }
                WebFault faultAnnotation = t.getClass().getAnnotation(WebFault.class);
                Object faultInfo = null;
                try {
                    Method method = t.getClass().getMethod("getFaultInfo", new Class[0]);
                    faultInfo = method.invoke((Object)t, new Object[0]);
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (faultAnnotation != null && faultInfo == null) {
                    Element detail = fault.getOrCreateDetail();
                    Element faultDetails = detail.getOwnerDocument().createElementNS(faultAnnotation.targetNamespace(), faultAnnotation.name());
                    detail.appendChild(faultDetails);
                }
                throw fault;
            }
        }
    }
}

