/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import jakarta.xml.ws.Provider;
import jakarta.xml.ws.WebServiceProvider;
import jakarta.xml.ws.handler.Handler;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.common.CxfBinding;
import org.apache.camel.component.cxf.common.CxfPayload;
import org.apache.camel.component.cxf.common.DataFormat;
import org.apache.camel.component.cxf.common.NullFaultListener;
import org.apache.camel.component.cxf.common.message.CxfConstants;
import org.apache.camel.component.cxf.feature.CXFMessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.feature.RAWDataFormatFeature;
import org.apache.camel.component.cxf.jaxws.ChainedCxfConfigurer;
import org.apache.camel.component.cxf.jaxws.CxfComponent;
import org.apache.camel.component.cxf.jaxws.CxfConfigurer;
import org.apache.camel.component.cxf.jaxws.CxfConsumer;
import org.apache.camel.component.cxf.jaxws.CxfEndpointUtils;
import org.apache.camel.component.cxf.jaxws.CxfProducer;
import org.apache.camel.component.cxf.jaxws.DefaultCxfBinding;
import org.apache.camel.component.cxf.jaxws.DefaultPayloadProviderSEI;
import org.apache.camel.component.cxf.jaxws.DefaultSEI;
import org.apache.camel.component.cxf.jaxws.HostnameVerifierCxfConfigurer;
import org.apache.camel.component.cxf.jaxws.HybridSourceDataBinding;
import org.apache.camel.component.cxf.jaxws.SslCxfConfigurer;
import org.apache.camel.component.cxf.jaxws.WSDLServiceFactoryBean;
import org.apache.camel.component.cxf.transport.header.CxfHeaderFilterStrategy;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.SynchronousDelegateProducer;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@UriEndpoint(firstVersion="1.0.0", scheme="cxf", title="CXF", syntax="cxf:beanId:address", category={Category.HTTP, Category.WEBSERVICE}, headersClass=CxfConstants.class)
public class CxfEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware,
Service,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(CxfEndpoint.class);
    @UriParam(label="advanced")
    protected Bus bus;
    @UriParam(label="advanced")
    protected boolean defaultBus;
    protected volatile boolean createBus;
    protected final AtomicBoolean getBusHasBeenCalled = new AtomicBoolean();
    private BindingConfiguration bindingConfig;
    private DataBinding dataBinding;
    private Object serviceFactoryBean;
    private List<Interceptor<? extends Message>> in = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> out = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> outFault = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> inFault = new ModCountCopyOnWriteArrayList();
    private List<Feature> features = new ModCountCopyOnWriteArrayList();
    private List<Handler> handlers;
    private List<String> schemaLocations;
    private String transportId;
    @UriPath(description="To lookup an existing configured CxfEndpoint. Must used bean: as prefix.")
    private String beanId;
    @UriParam(defaultValue="POJO")
    private DataFormat dataFormat = DataFormat.POJO;
    @UriPath(label="service")
    private String address;
    @UriParam(label="service")
    private String wsdlURL;
    @UriParam(label="service")
    private Class<?> serviceClass;
    @UriParam(label="service")
    private String portName;
    private transient QName portNameQName;
    @UriParam(label="service")
    private String serviceName;
    private transient QName serviceNameQName;
    @UriParam(label="service")
    private String bindingId;
    @UriParam(label="service")
    private String publishedEndpointUrl;
    @UriParam(label="producer")
    private String defaultOperationName;
    @UriParam(label="producer")
    private String defaultOperationNamespace;
    @UriParam(label="producer")
    private boolean wrapped;
    @UriParam(label="producer")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="producer")
    private HostnameVerifier hostnameVerifier;
    @UriParam
    private Boolean wrappedStyle;
    @UriParam(label="advanced")
    private Boolean allowStreaming;
    @UriParam(label="advanced")
    private CxfBinding cxfBinding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="logging")
    private boolean loggingFeatureEnabled;
    @UriParam(label="logging", defaultValue="49152")
    private int loggingSizeLimit;
    @UriParam(label="advanced")
    private boolean mtomEnabled;
    @UriParam(label="advanced")
    private boolean skipPayloadMessagePartCheck;
    @UriParam(label="logging")
    private boolean skipFaultLogging;
    @UriParam(label="advanced")
    private boolean mergeProtocolHeaders;
    @UriParam(label="advanced")
    private CxfConfigurer cxfConfigurer;
    @UriParam(label="advanced", defaultValue="30000", javaType="java.time.Duration")
    private long continuationTimeout = 30000L;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced", prefix="properties.", multiValue=true)
    private Map<String, Object> properties;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;
    @UriParam(defaultValue="false", label="producer,advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;
    @UriParam(defaultValue="false", label="advanced", description="Enable schema validation for request and response. Disabled by default for performance reason")
    private Boolean schemaValidationEnabled;

    public CxfEndpoint() {
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public CxfEndpoint(String remaining, CxfComponent cxfComponent) {
        super(remaining, (Component)cxfComponent);
        this.setAddress(remaining);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public CxfEndpoint copy() {
        try {
            return (CxfEndpoint)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(UnsafeUriCharactersEncoder.encodeHttpURI((String)endpointUri));
    }

    public Producer createProducer() throws Exception {
        CxfProducer answer = new CxfProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CxfConsumer answer = new CxfConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected void setupServerFactoryBean(ServerFactoryBean sfb, Class<?> cls) {
        sfb.setAddress(this.getAddress());
        sfb.setServiceClass(cls);
        sfb.setInInterceptors(this.in);
        sfb.setOutInterceptors(this.out);
        sfb.setOutFaultInterceptors(this.outFault);
        sfb.setInFaultInterceptors(this.inFault);
        sfb.setFeatures(this.features);
        if (this.schemaLocations != null) {
            sfb.setSchemaLocations(this.schemaLocations);
        }
        if (this.bindingConfig != null) {
            sfb.setBindingConfig(this.bindingConfig);
        }
        if (this.dataBinding != null) {
            sfb.setDataBinding(this.dataBinding);
        }
        if (this.serviceFactoryBean != null) {
            this.setServiceFactory(sfb, this.serviceFactoryBean);
        }
        if (sfb instanceof JaxWsServerFactoryBean && this.handlers != null) {
            ((JaxWsServerFactoryBean)sfb).setHandlers(this.handlers);
        }
        if (this.getTransportId() != null) {
            sfb.setTransportId(this.getTransportId());
        }
        if (this.getBindingId() != null) {
            sfb.setBindingId(this.getBindingId());
        }
        if (this.getWsdlURL() != null) {
            sfb.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceNameAsQName() != null) {
            sfb.setServiceName(this.getServiceNameAsQName());
        }
        if (this.getPortNameAsQName() != null) {
            sfb.setEndpointName(this.getPortNameAsQName());
        }
        if (!CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class)) {
            if (this.getDataFormat() == DataFormat.PAYLOAD) {
                sfb.getFeatures().add(new PayLoadDataFormatFeature(this.allowStreaming));
            } else if (this.getDataFormat().dealias() == DataFormat.CXF_MESSAGE) {
                sfb.getFeatures().add(new CXFMessageDataFormatFeature());
                sfb.setDataBinding((DataBinding)new SourceDataBinding());
            } else if (this.getDataFormat().dealias() == DataFormat.RAW) {
                RAWDataFormatFeature feature = new RAWDataFormatFeature();
                if (this.getExchangePattern().equals((Object)ExchangePattern.InOnly)) {
                    feature.setOneway(true);
                }
                feature.addInIntercepters(this.getInInterceptors());
                feature.addOutInterceptors(this.getOutInterceptors());
                sfb.getFeatures().add(feature);
            }
        } else {
            LOG.debug("Ignore DataFormat mode {} since SEI class is annotated with WebServiceProvider", (Object)this.getDataFormat());
        }
        if (this.isLoggingFeatureEnabled()) {
            LoggingFeature loggingFeature = new LoggingFeature();
            if (this.getLoggingSizeLimit() >= -1) {
                loggingFeature.setLimit(this.getLoggingSizeLimit());
            }
            sfb.getFeatures().add(loggingFeature);
        }
        if (this.getDataFormat() == DataFormat.PAYLOAD) {
            sfb.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.getWrappedStyle() != null && this.getDataFormat().dealias() != DataFormat.CXF_MESSAGE) {
            this.setWrapped(sfb, this.getWrappedStyle());
        }
        if (this.getProperties() != null) {
            if (sfb.getProperties() != null) {
                sfb.getProperties().putAll(this.getProperties());
            } else {
                sfb.setProperties(this.getProperties());
            }
            LOG.debug("ServerFactoryBean: {} added properties: {}", (Object)sfb, this.getProperties());
        }
        if (this.isSkipPayloadMessagePartCheck()) {
            if (sfb.getProperties() == null) {
                sfb.setProperties(new HashMap());
            }
            sfb.getProperties().put("soap.no.validate.parts", Boolean.TRUE);
        }
        if (this.isSkipFaultLogging()) {
            if (sfb.getProperties() == null) {
                sfb.setProperties(new HashMap());
            }
            sfb.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        if (this.getSchemaValidationEnabled() != null) {
            if (sfb.getProperties() == null) {
                sfb.setProperties(new HashMap());
            }
            sfb.getProperties().put("schema-validation-enabled", this.schemaValidationEnabled);
        }
        sfb.setBus(this.getBus());
        sfb.setStart(false);
        this.getNullSafeCxfConfigurer().configure((AbstractWSDLBasedEndpointFactory)sfb);
    }

    public ClientFactoryBean createClientFactoryBean(Class<?> cls) {
        if (CxfEndpointUtils.hasWebServiceAnnotation(cls)) {
            return new JaxWsClientFactoryBean(){

                protected Client createClient(Endpoint ep) {
                    return new CamelCxfClientImpl(this.getBus(), ep);
                }
            };
        }
        return new ClientFactoryBean(){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }
        };
    }

    protected ClientFactoryBean createClientFactoryBean() {
        ClientFactoryBean cf = new ClientFactoryBean(){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }

            protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> cls) {
            }
        };
        for (Method m : cf.getClass().getMethods()) {
            if (!"setServiceFactory".equals(m.getName())) continue;
            try {
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)cf, new Object[]{new WSDLServiceFactoryBean(Object.class)});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return cf;
    }

    protected void setupHandlers(ClientFactoryBean factoryBean, Client client) throws Exception {
        if (this.handlers != null) {
            AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
            Method m = factoryBean.getClass().getMethod("getServiceFactory", new Class[0]);
            JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)m.invoke((Object)factoryBean, new Object[0]);
            ArrayList<Handler> chain = new ArrayList<Handler>(this.handlers);
            chain.addAll(builder.buildHandlerChainFromClass(sf.getServiceClass(), sf.getEndpointInfo().getName(), sf.getServiceQName(), factoryBean.getBindingId()));
            if (!chain.isEmpty()) {
                ResourceManager resourceManager = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
                List resolvers = resourceManager.getResourceResolvers();
                resourceManager = new DefaultResourceManager(resolvers);
                resourceManager.addResourceResolver((ResourceResolver)new WebServiceContextResourceResolver());
                ResourceInjector injector = new ResourceInjector(resourceManager);
                for (Handler h : chain) {
                    if (Proxy.isProxyClass(h.getClass()) && this.getServiceClass() != null) {
                        injector.inject((Object)h, this.getServiceClass());
                        injector.construct((Object)h, this.getServiceClass());
                        continue;
                    }
                    injector.inject((Object)h);
                    injector.construct((Object)h);
                }
            }
            ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
        }
    }

    protected void setupClientFactoryBean(ClientFactoryBean factoryBean, Class<?> cls) {
        if (cls != null) {
            factoryBean.setServiceClass(cls);
        }
        factoryBean.setInInterceptors(this.in);
        factoryBean.setOutInterceptors(this.out);
        factoryBean.setOutFaultInterceptors(this.outFault);
        factoryBean.setInFaultInterceptors(this.inFault);
        factoryBean.setFeatures(this.features);
        factoryBean.setTransportId(this.transportId);
        factoryBean.setBindingId(this.bindingId);
        if (this.bindingConfig != null) {
            factoryBean.setBindingConfig(this.bindingConfig);
        }
        if (this.dataBinding != null) {
            factoryBean.setDataBinding(this.dataBinding);
        }
        if (this.serviceFactoryBean != null) {
            this.setServiceFactory(factoryBean, this.serviceFactoryBean);
        }
        factoryBean.setAddress(this.getAddress());
        if (this.getWsdlURL() != null) {
            factoryBean.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceNameAsQName() != null) {
            factoryBean.setServiceName(this.getServiceNameAsQName());
        }
        if (this.getPortNameAsQName() != null) {
            factoryBean.setEndpointName(this.getPortNameAsQName());
        }
        if (this.getDataFormat().dealias() == DataFormat.RAW) {
            RAWDataFormatFeature feature = new RAWDataFormatFeature();
            feature.addInIntercepters(this.getInInterceptors());
            feature.addOutInterceptors(this.getOutInterceptors());
            factoryBean.getFeatures().add(feature);
        } else if (this.getDataFormat().dealias() == DataFormat.CXF_MESSAGE) {
            factoryBean.getFeatures().add(new CXFMessageDataFormatFeature());
            factoryBean.setDataBinding((DataBinding)new SourceDataBinding());
        } else if (this.getDataFormat() == DataFormat.PAYLOAD) {
            factoryBean.getFeatures().add(new PayLoadDataFormatFeature(this.allowStreaming));
            factoryBean.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.isLoggingFeatureEnabled()) {
            LoggingFeature loggingFeature = new LoggingFeature();
            if (this.getLoggingSizeLimit() >= -1) {
                loggingFeature.setLimit(this.getLoggingSizeLimit());
            }
            factoryBean.getFeatures().add(loggingFeature);
        }
        if (this.getWrappedStyle() != null) {
            this.setWrapped(factoryBean, this.getWrappedStyle());
        }
        if (this.getProperties() != null) {
            if (factoryBean.getProperties() != null) {
                factoryBean.getProperties().putAll(this.getProperties());
            } else {
                factoryBean.setProperties(this.getProperties());
            }
            LOG.debug("ClientFactoryBean: {} added properties: {}", (Object)factoryBean, this.getProperties());
        }
        if (ObjectHelper.isNotEmpty((String)this.username)) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            if (factoryBean.getProperties() == null) {
                factoryBean.setProperties(new HashMap());
            }
            factoryBean.getProperties().put(AuthorizationPolicy.class.getName(), authPolicy);
        }
        if (this.isSkipPayloadMessagePartCheck()) {
            if (factoryBean.getProperties() == null) {
                factoryBean.setProperties(new HashMap());
            }
            factoryBean.getProperties().put("soap.no.validate.parts", Boolean.TRUE);
        }
        if (this.isSkipFaultLogging()) {
            if (factoryBean.getProperties() == null) {
                factoryBean.setProperties(new HashMap());
            }
            factoryBean.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        if (this.getSchemaValidationEnabled() != null) {
            if (factoryBean.getProperties() == null) {
                factoryBean.setProperties(new HashMap());
            }
            factoryBean.getProperties().put("schema-validation-enabled", this.schemaValidationEnabled);
        }
        factoryBean.setBus(this.getBus());
        this.getNullSafeCxfConfigurer().configure((AbstractWSDLBasedEndpointFactory)factoryBean);
    }

    private void setWrapped(Object factoryBean, boolean wrapped) {
        try {
            Object sf = factoryBean.getClass().getMethod("getServiceFactory", new Class[0]).invoke(factoryBean, new Object[0]);
            sf.getClass().getMethod("setWrapped", Boolean.TYPE).invoke(sf, wrapped);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    private void setServiceFactory(Object factoryBean, Object serviceFactoryBean2) {
        for (Method m : factoryBean.getClass().getMethods()) {
            if (!"setServiceFactory".equals(m.getName()) || !m.getParameterTypes()[0].isInstance(serviceFactoryBean2)) continue;
            try {
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke(factoryBean, serviceFactoryBean2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Client createClient() throws Exception {
        Class<?> cls;
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && this.getServiceClass() == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
        }
        ClientFactoryBean factoryBean = (cls = this.getServiceClass()) != null ? this.createClientFactoryBean(cls) : this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean, cls);
        if (cls == null) {
            this.checkName(factoryBean.getEndpointName(), "endpoint/port name");
            this.checkName(factoryBean.getServiceName(), "service name");
        }
        Client client = factoryBean.create();
        this.setupHandlers(factoryBean, client);
        return client;
    }

    public void checkName(Object value, String name) {
        if (ObjectHelper.isEmpty((Object)value)) {
            LOG.warn("The {} of {} is empty, cxf will try to load the first one in wsdl for you.", (Object)name, (Object)this.getEndpointUri());
        }
    }

    protected ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<Object> cls = null;
        if (this.getDataFormat() == DataFormat.POJO) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && this.getServiceClass() == null && this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
            this.setServiceClass(DefaultPayloadProviderSEI.class.getName());
        }
        if (this.getServiceClass() != null) {
            cls = this.getServiceClass();
        }
        Object answer = null;
        if (cls == null) {
            this.checkName(this.portName, " endpoint/port name");
            this.checkName(this.serviceName, " service name");
            answer = new JaxWsServerFactoryBean((JaxWsServiceFactoryBean)new WSDLServiceFactoryBean());
            cls = Provider.class;
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        return answer;
    }

    protected String resolvePropertyPlaceholders(String str) {
        try {
            if (this.getCamelContext() != null) {
                return this.getCamelContext().resolvePropertyPlaceholders(str);
            }
            return str;
        }
        catch (Exception ex) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)ex);
        }
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public String getPublishedEndpointUrl() {
        return this.resolvePropertyPlaceholders(this.publishedEndpointUrl);
    }

    public void setPublishedEndpointUrl(String url) {
        this.publishedEndpointUrl = url;
    }

    public String getWsdlURL() {
        return this.resolvePropertyPlaceholders(this.wsdlURL);
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> cls) {
        this.serviceClass = cls;
    }

    public void setServiceClass(Object instance) {
        this.serviceClass = ClassHelper.getRealClass((Object)instance);
    }

    public void setServiceClass(String type) throws ClassNotFoundException {
        if (ObjectHelper.isEmpty((String)type)) {
            throw new IllegalArgumentException("The serviceClass option can neither be null nor an empty String.");
        }
        this.serviceClass = ClassLoaderUtils.loadClass((String)this.resolvePropertyPlaceholders(type), this.getClass());
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public QName getServiceNameAsQName() {
        if (this.serviceNameQName == null && this.serviceName != null) {
            this.serviceNameQName = QName.valueOf(this.resolvePropertyPlaceholders(this.serviceName));
        }
        if (this.serviceNameQName == null && this.getWsdlURL() != null) {
            try {
                Definition definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.getWsdlURL());
                if (definition.getServices().size() == 1) {
                    this.serviceNameQName = (QName)definition.getServices().keySet().iterator().next();
                }
            }
            catch (WSDLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.serviceNameQName;
    }

    public void setServiceNameAsQName(QName qName) {
        this.serviceNameQName = qName;
    }

    public QName getPortNameAsQName() {
        if (this.portNameQName == null && this.portName != null) {
            this.portNameQName = QName.valueOf(this.resolvePropertyPlaceholders(this.portName));
        }
        return this.portNameQName;
    }

    public void setPortNameAsQName(QName qName) {
        this.portNameQName = qName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public void setEndpointName(String name) {
        this.portName = name;
    }

    public void setEndpointNameAsQName(QName qName) {
        this.portNameQName = qName;
    }

    public String getDefaultOperationName() {
        return this.resolvePropertyPlaceholders(this.defaultOperationName);
    }

    public void setDefaultOperationName(String name) {
        this.defaultOperationName = name;
    }

    public String getDefaultOperationNamespace() {
        return this.resolvePropertyPlaceholders(this.defaultOperationNamespace);
    }

    public void setDefaultOperationNamespace(String namespace) {
        this.defaultOperationNamespace = namespace;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public Boolean getWrappedStyle() {
        return this.wrappedStyle;
    }

    public void setWrappedStyle(Boolean wrapped) {
        this.wrappedStyle = wrapped;
    }

    public void setAllowStreaming(Boolean allowStreaming) {
        this.allowStreaming = allowStreaming;
    }

    public Boolean getAllowStreaming() {
        return this.allowStreaming;
    }

    public void setCxfBinding(CxfBinding cxfBinding) {
        this.cxfBinding = cxfBinding;
    }

    public CxfBinding getCxfBinding() {
        return this.cxfBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
        this.createBus = false;
    }

    public Bus getBus() {
        if (this.bus == null) {
            CamelContext context = this.getCamelContext();
            if (context.getClass().getName().endsWith("SpringCamelContext") || context.getClass().getName().endsWith("SpringBootCamelContext")) {
                try {
                    Class<?> cxfSpringEndpintUtilClazz = Class.forName("org.apache.camel.component.cxf.spring.jaxws.CxfSpringEndpointUtils");
                    Method method = cxfSpringEndpintUtilClazz.getMethod("createBus", CamelContext.class);
                    this.bus = (Bus)method.invoke(null, context);
                }
                catch (Exception ex) {
                    if (context.getClass().getName().endsWith("SpringCamelContext")) {
                        LOG.warn("Error creating Cxf Bus from SpringCamelContext: {} This exception will be ignored.", (Object)ex.getMessage(), (Object)ex);
                    } else {
                        LOG.warn("Error creating Cxf Bus from SpringBootCamelContext: {} This exception will be ignored.", (Object)ex.getMessage(), (Object)ex);
                    }
                    this.bus = CxfEndpointUtils.createBus();
                }
            } else {
                this.bus = CxfEndpointUtils.createBus();
            }
            this.createBus = true;
            LOG.debug("Using DefaultBus {}", (Object)this.bus);
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.defaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            LOG.debug("Set bus {} as thread default bus", (Object)this.bus);
        }
        return this.bus;
    }

    public void setDefaultBus(boolean defaultBus) {
        this.defaultBus = defaultBus;
    }

    public boolean isDefaultBus() {
        return this.defaultBus;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        if (loggingSizeLimit < -1) {
            throw new IllegalArgumentException("LoggingSizeLimit must be greater or equal to -1.");
        }
        this.loggingSizeLimit = loggingSizeLimit;
    }

    public boolean isSkipPayloadMessagePartCheck() {
        return this.skipPayloadMessagePartCheck;
    }

    public void setSkipPayloadMessagePartCheck(boolean skipPayloadMessagePartCheck) {
        this.skipPayloadMessagePartCheck = skipPayloadMessagePartCheck;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCamelContext(CamelContext c) {
        super.setCamelContext(c);
        if (this.properties != null) {
            try {
                PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
            }
            catch (Exception e) {
                LOG.warn("Error setting CamelContext. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll(properties);
        }
        if (this.getCamelContext() != null && this.properties != null) {
            try {
                PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
            }
            catch (Exception e) {
                LOG.warn("Error setting properties. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfHeaderFilterStrategy();
        }
        if (this.cxfBinding == null) {
            this.cxfBinding = new DefaultCxfBinding();
        }
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    protected void doStop() throws Exception {
        if (this.createBus && this.bus != null) {
            LOG.debug("Shutdown CXF bus {}", (Object)this.bus);
            this.getBus().shutdown(false);
            this.bus = null;
        }
    }

    public void setAddress(String address) {
        super.setEndpointUri(UnsafeUriCharactersEncoder.encodeHttpURI((String)address));
        this.address = address;
    }

    public String getAddress() {
        return this.resolvePropertyPlaceholders(this.address);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public CxfConfigurer getChainedCxfConfigurer() {
        return ChainedCxfConfigurer.create(this.getNullSafeCxfConfigurer(), SslCxfConfigurer.create(this.sslContextParameters, this.getCamelContext())).addChild(HostnameVerifierCxfConfigurer.create(this.hostnameVerifier));
    }

    private CxfConfigurer getNullSafeCxfConfigurer() {
        if (this.cxfConfigurer == null) {
            return new ChainedCxfConfigurer.NullCxfConfigurer();
        }
        return this.cxfConfigurer;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFault;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFault;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.in;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.in = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.out = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outFault = interceptors;
    }

    public void setFeatures(List<Feature> f) {
        this.features = f;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers = h;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setSchemaLocations(List<String> sc) {
        this.schemaLocations = sc;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public String getTransportId() {
        return this.resolvePropertyPlaceholders(this.transportId);
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public String getBindingId() {
        return this.resolvePropertyPlaceholders(this.bindingId);
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public BindingConfiguration getBindingConfig() {
        return this.bindingConfig;
    }

    public boolean isSkipFaultLogging() {
        return this.skipFaultLogging;
    }

    public void setSkipFaultLogging(boolean skipFaultLogging) {
        this.skipFaultLogging = skipFaultLogging;
    }

    public boolean isMergeProtocolHeaders() {
        return this.mergeProtocolHeaders;
    }

    public void setMergeProtocolHeaders(boolean mergeProtocolHeaders) {
        this.mergeProtocolHeaders = mergeProtocolHeaders;
    }

    public void setBindingConfig(BindingConfiguration bindingConfig) {
        this.bindingConfig = bindingConfig;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    public Object getServiceFactoryBean() {
        return this.serviceFactoryBean;
    }

    public void setServiceFactoryBean(Object serviceFactoryBean) {
        this.serviceFactoryBean = serviceFactoryBean;
    }

    public void setServiceFactory(Object serviceFactoryBean) {
        this.serviceFactoryBean = serviceFactoryBean;
    }

    public CxfConfigurer getCxfConfigurer() {
        return this.cxfConfigurer;
    }

    public void setCxfConfigurer(CxfConfigurer configurer) {
        this.cxfConfigurer = configurer;
    }

    public long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    URI getRequestUri(Exchange camelExchange) {
        String uriString = (String)camelExchange.getIn().getHeader("CamelDestinationOverrideUrl", String.class);
        if (uriString == null) {
            uriString = this.getAddress();
        }
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            LOG.error("cannot determine request URI", (Throwable)e);
            return null;
        }
    }

    public Boolean getSchemaValidationEnabled() {
        return this.schemaValidationEnabled;
    }

    public void setSchemaValidationEnabled(Boolean schemaValidationEnabled) {
        this.schemaValidationEnabled = schemaValidationEnabled;
    }

    public class CamelCxfClientImpl
    extends ClientImpl {
        CamelCxfClientImpl(Bus bus, Endpoint ep) {
            super(bus, ep);
        }

        protected Object[] processResult(Message message, org.apache.cxf.message.Exchange exchange, BindingOperationInfo oi, Map<String, Object> resContext) throws Exception {
            try {
                return super.processResult(message, exchange, oi, resContext);
            }
            catch (ClientImpl.IllegalEmptyResponseException ex) {
                return null;
            }
        }

        protected void setParameters(Object[] params, Message message) {
            Object attachments = message.get((Object)"CamelAttachments");
            if (attachments != null) {
                message.setAttachments((Collection)attachments);
                message.remove((Object)"CamelAttachments");
            }
            if (DataFormat.PAYLOAD == message.get(DataFormat.class) && params[0] instanceof CxfPayload) {
                CxfPayload payload = (CxfPayload)params[0];
                List elements = payload.getBodySources();
                BindingOperationInfo boi = (BindingOperationInfo)message.get(BindingOperationInfo.class);
                MessageContentsList content = new MessageContentsList();
                int i = 0;
                for (MessagePartInfo partInfo : boi.getInput().getMessageParts()) {
                    if (elements.size() <= i) continue;
                    if (CxfEndpoint.this.isSkipPayloadMessagePartCheck()) {
                        content.put(partInfo, elements.get(i++));
                        continue;
                    }
                    String name = this.findName(elements, i);
                    if (!partInfo.getConcreteName().getLocalPart().equals(name)) continue;
                    content.put(partInfo, elements.get(i++));
                }
                if (elements != null && content.size() < elements.size()) {
                    throw new IllegalArgumentException("The PayLoad elements cannot fit with the message parts of the BindingOperation. Please check the BindingOperation and PayLoadMessage.");
                }
                message.setContent(List.class, (Object)content);
                List headerListOfRequestContxt = (List)message.get((Object)Header.HEADER_LIST);
                List headerListOfPayload = CastUtils.cast((List)payload.getHeaders());
                if (headerListOfRequestContxt != headerListOfPayload) {
                    if (headerListOfRequestContxt == null) {
                        message.put((Object)Header.HEADER_LIST, (Object)payload.getHeaders());
                    } else {
                        headerListOfRequestContxt.addAll(headerListOfPayload);
                    }
                }
            } else {
                super.setParameters(params, message);
            }
            message.remove((Object)DataFormat.class.getName());
        }

        private String findName(List<Source> sources, int i) {
            Source source = sources.get(i);
            XMLStreamReader r = null;
            if (source instanceof DOMSource) {
                Node nd = ((DOMSource)source).getNode();
                if (nd instanceof Document) {
                    nd = ((Document)nd).getDocumentElement();
                }
                return nd.getLocalName();
            }
            if (source instanceof StaxSource) {
                s = (StaxSource)source;
                r = s.getXMLStreamReader();
            } else if (source instanceof StAXSource) {
                s = (StAXSource)source;
                r = ((StAXSource)s).getXMLStreamReader();
            } else if (source instanceof StreamSource || source instanceof SAXSource) {
                r = StaxUtils.createXMLStreamReader((Source)source);
                StaxSource src2 = new StaxSource(r);
                sources.set(i, (Source)src2);
            }
            if (r != null) {
                try {
                    if (r.getEventType() == 7) {
                        r.next();
                    }
                    if (r.getEventType() != 1) {
                        r.nextTag();
                    }
                }
                catch (XMLStreamException e) {
                    LOG.warn("Error finding the start element.", (Throwable)e);
                    return null;
                }
                return r.getLocalName();
            }
            return null;
        }
    }
}

