/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.header;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;

public final class CxfHeaderHelper {
    private CxfHeaderHelper() {
    }

    public static void propagateCamelToCxf(HeaderFilterStrategy strategy, Map<String, Object> headers, Message message, Exchange exchange) {
        TreeMap cxfHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (cxfHeaders == null) {
            cxfHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put((Object)Message.PROTOCOL_HEADERS, cxfHeaders);
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (strategy == null || strategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            if ("Content-Type".equals(entry.getKey())) {
                message.put((Object)"Content-Type", entry.getValue());
                continue;
            }
            if ("RequestContext".equals(entry.getKey()) || "ResponseContext".equals(entry.getKey()) || Message.RESPONSE_CODE.equals(entry.getKey())) {
                message.put((Object)entry.getKey(), entry.getValue());
                continue;
            }
            ArrayList<String> listValue = new ArrayList<String>();
            listValue.add(entry.getValue().toString());
            cxfHeaders.put(entry.getKey(), listValue);
        }
    }

    public static void propagateCxfToCamel(HeaderFilterStrategy strategy, Message message, Map<String, Object> headers, Exchange exchange) {
        if (strategy == null) {
            return;
        }
        Map cxfHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                headers.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
            }
        }
        String key = "Content-Type";
        Object value = CxfHeaderHelper.determineContentType(message);
        if (value != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            headers.put("Content-Type", value);
        }
        if ((value = message.get((Object)(key = "RequestContext"))) != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            headers.put(key, value);
        }
        if ((value = message.get((Object)(key = "ResponseContext"))) != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            headers.put(key, value);
        }
        if ((value = message.get((Object)(key = Message.RESPONSE_CODE))) != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            headers.put("CamelHttpResponseCode", value);
        }
    }

    private static String determineContentType(Message message) {
        String ct = (String)message.get((Object)"Content-Type");
        String enc = (String)message.get((Object)Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        message.put((Object)"Content-Type", (Object)ct);
        return ct;
    }
}

