/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.common.header.CxfHeaderHelper;
import org.apache.camel.component.cxf.common.message.CxfMessageHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CamelOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CamelOutputStream.class);
    private Message outMessage;
    private boolean isOneWay;
    private String targetCamelEndpointUri;
    private Producer producer;
    private HeaderFilterStrategy headerFilterStrategy;
    private MessageObserver observer;

    public CamelOutputStream(String targetCamelEndpointUri, Producer producer, HeaderFilterStrategy headerFilterStrategy, MessageObserver observer, Message m) {
        this.targetCamelEndpointUri = targetCamelEndpointUri;
        this.producer = producer;
        this.headerFilterStrategy = headerFilterStrategy;
        this.observer = observer;
        this.outMessage = m;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.isOneWay = this.outMessage.getExchange().isOneWay();
        this.commitOutputMessage();
    }

    protected void onWrite() throws IOException {
    }

    private void commitOutputMessage() throws IOException {
        ExchangePattern pattern = this.isOneWay ? ExchangePattern.InOnly : ExchangePattern.InOut;
        LOG.debug("send the message to endpoint {}", (Object)this.targetCamelEndpointUri);
        Exchange exchange = this.producer.createExchange(pattern);
        exchange.setProperty("CamelToEndpoint", (Object)this.targetCamelEndpointUri);
        CachedOutputStream outputStream = (CachedOutputStream)this.outMessage.getContent(OutputStream.class);
        CxfHeaderHelper.propagateCxfToCamel(this.headerFilterStrategy, this.outMessage, exchange.getIn().getHeaders(), exchange);
        exchange.getIn().setBody((Object)outputStream.getInputStream());
        LOG.debug("template sending request: ", (Object)exchange.getIn());
        try {
            this.producer.process(exchange);
        }
        catch (Exception ex) {
            Exception exception = ex;
        }
        Exception exception = exchange.getException();
        if (exception != null) {
            throw new IOException("Cannot send the request message.", exchange.getException());
        }
        exchange.setProperty("org.apache.cxf.message.exchange", (Object)this.outMessage.getExchange());
        if (!this.isOneWay) {
            this.handleResponse(exchange);
        }
    }

    private void handleResponse(Exchange exchange) throws IOException {
        Message inMessage = null;
        try {
            inMessage = CxfMessageHelper.getCxfInMessage(this.headerFilterStrategy, exchange, true);
        }
        catch (Exception ex) {
            throw new IOException("Cannot get the response message. ", ex);
        }
        this.observer.onMessage(inMessage);
    }
}

