/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.MessageContext;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.headers.Direction;
import org.apache.camel.component.cxf.headers.MessageHeadersRelay;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfBinding {
    private static final Logger LOG = LogUtils.getL7dLogger(CxfBinding.class);

    private CxfBinding() {
    }

    public static Object extractBodyFromCxf(CxfExchange exchange, org.apache.cxf.message.Message message) {
        return CxfBinding.getBody(message);
    }

    protected static Object getBody(org.apache.cxf.message.Message message) {
        Set contentFormats = message.getContentFormats();
        if (contentFormats != null) {
            for (Class contentFormat : contentFormats) {
                Object answer = message.getContent(contentFormat);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public static org.apache.cxf.message.Message createCxfMessage(CxfExchange exchange) {
        return CxfBinding.createCxfMessage((HeaderFilterStrategy)new CxfHeaderFilterStrategy(), exchange);
    }

    public static org.apache.cxf.message.Message createCxfMessage(HeaderFilterStrategy strategy, CxfExchange exchange) {
        Message in;
        Object body;
        org.apache.cxf.message.Message answer = exchange.getInMessage();
        if (answer == null) {
            answer = new MessageImpl();
        }
        if ((body = (in = exchange.getIn()).getBody()) instanceof List) {
            answer.setContent(List.class, body);
            CxfHeaderHelper.propagateCamelToCxf(strategy, in.getHeaders(), answer);
        } else {
            try {
                InputStream is = (InputStream)in.getBody(InputStream.class);
                answer.setContent(InputStream.class, (Object)is);
            }
            catch (NoTypeConversionAvailableException ex2) {
                // empty catch block
            }
        }
        HashMap requestContext = CastUtils.cast((Map)((Map)answer.get((Object)"RequestContext")));
        if (requestContext == null) {
            requestContext = new HashMap();
        }
        if (exchange.getExchange() != null) {
            requestContext.putAll(exchange.getExchange());
        }
        if (exchange.getProperties() != null) {
            requestContext.putAll(exchange.getProperties());
        }
        requestContext.remove(HandlerChainInvoker.class.getName());
        answer.put((Object)"RequestContext", requestContext);
        return answer;
    }

    public static void storeCxfResponse(CxfExchange exchange, org.apache.cxf.message.Message response) {
        CxfBinding.storeCxfResponse((HeaderFilterStrategy)new CxfHeaderFilterStrategy(), exchange, response);
    }

    public static void storeCxfResponse(HeaderFilterStrategy strategy, CxfExchange exchange, org.apache.cxf.message.Message response) {
        Message out = exchange.getOut();
        if (response != null) {
            out.getHeaders().putAll(exchange.getIn().getHeaders());
            CxfHeaderHelper.propagateCxfToCamel(strategy, response, out.getHeaders());
            if (out instanceof CxfMessage) {
                ((CxfMessage)out).setMessage(response);
            } else {
                out.setBody(response.get(List.class));
            }
            DataFormat dataFormat = (DataFormat)((Object)exchange.getProperty("CamelCXFDataFormat"));
            if (dataFormat.equals((Object)DataFormat.MESSAGE)) {
                out.setBody(response.getContent(InputStream.class));
            }
            if (dataFormat.equals((Object)DataFormat.PAYLOAD)) {
                out.setBody((Object)response);
            }
        }
    }

    public static void copyMessage(Message camelMessage, org.apache.cxf.message.Message cxfMessage) {
        CxfBinding.copyMessage((HeaderFilterStrategy)new CxfHeaderFilterStrategy(), camelMessage, cxfMessage);
    }

    public static void copyMessage(HeaderFilterStrategy strategy, Message camelMessage, org.apache.cxf.message.Message cxfMessage) {
        CxfHeaderHelper.propagateCamelToCxf(strategy, camelMessage.getHeaders(), cxfMessage);
        try {
            InputStream is = (InputStream)camelMessage.getBody(InputStream.class);
            if (is != null) {
                cxfMessage.setContent(InputStream.class, (Object)is);
            }
        }
        catch (NoTypeConversionAvailableException ex) {
            Object result = camelMessage.getBody();
            if (result instanceof InputStream) {
                cxfMessage.setContent(InputStream.class, result);
            }
            cxfMessage.setContent(result.getClass(), result);
        }
    }

    public static void storeCXfResponseContext(org.apache.cxf.message.Message response, Map<String, Object> context) {
        if (context != null) {
            WrappedMessageContext messageContext = new WrappedMessageContext(context, null, MessageContext.Scope.HANDLER);
            response.put((Object)"ResponseContext", (Object)messageContext);
            Map protocolHeaders = CastUtils.cast((Map)((Map)messageContext.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
            response.put((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, (Object)protocolHeaders);
            Object value = context.get(org.apache.cxf.message.Message.RESPONSE_CODE);
            if (value != null) {
                response.put((Object)org.apache.cxf.message.Message.RESPONSE_CODE, value);
            }
        }
    }

    public static void storeCxfResponse(CxfExchange exchange, Object response) {
        Message out = exchange.getOut();
        if (response != null) {
            out.setBody(response);
        }
    }

    public static void storeCxfFault(CxfExchange exchange, org.apache.cxf.message.Message message) {
        Message fault = exchange.getFault();
        if (fault != null) {
            fault.setBody(CxfBinding.getBody(message));
        }
    }

    public static Map<String, Object> propogateContext(CxfExchange exchange, Map<String, Object> context) {
        org.apache.cxf.message.Message message = exchange.getInMessage();
        Map requestContext = CastUtils.cast((Map)((Map)message.get((Object)"RequestContext")));
        HashMap<String, Object> responseContext = CastUtils.cast((Map)((Map)message.get((Object)"ResponseContext")));
        Map camelRequestContext = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("RequestContext")));
        HashMap mergedRequestContext = new HashMap();
        WrappedMessageContext ctx = new WrappedMessageContext(mergedRequestContext, null, MessageContext.Scope.APPLICATION);
        if (requestContext != null) {
            ctx.putAll(requestContext);
        }
        if (camelRequestContext != null) {
            ctx.putAll(camelRequestContext);
        }
        if (ctx.size() > 0) {
            ctx.getScopes().remove(org.apache.cxf.message.Message.PROTOCOL_HEADERS);
        }
        if (responseContext == null) {
            responseContext = new HashMap<String, Object>();
        } else {
            responseContext.clear();
        }
        context.put("RequestContext", mergedRequestContext);
        context.put("ResponseContext", responseContext);
        return responseContext;
    }

    protected static void relayRequestHeaders(CxfEndpoint endpoint, CxfExchange exchange, Map<String, Object> context) {
        org.apache.cxf.message.Message message = exchange.getInMessage();
        if (message == null) {
            return;
        }
        Map requestContext = CastUtils.cast((Map)((Map)context.get("RequestContext")));
        if (!endpoint.isRelayHeaders()) {
            message.remove((Object)Header.HEADER_LIST);
            if (exchange.getExchange() == null) {
                return;
            }
            BindingOperationInfo bop = (BindingOperationInfo)exchange.getExchange().get(BindingOperationInfo.class);
            if (null == bop) {
                return;
            }
            BindingMessageInfo bmi = bop.getInput();
            List headersInfo = bmi.getExtensors(SoapHeaderInfo.class);
            if (headersInfo == null || headersInfo.size() == 0) {
                return;
            }
            MessageContentsList parameters = MessageContentsList.getContentsList((org.apache.cxf.message.Message)message);
            for (SoapHeaderInfo headerInfo : headersInfo) {
                Object o = parameters.get(headerInfo.getPart());
                if (o instanceof Holder) {
                    Holder holder = (Holder)o;
                    holder.value = null;
                    continue;
                }
                parameters.remove(headerInfo.getPart());
            }
            return;
        }
        if (!message.containsKey((Object)Header.HEADER_LIST)) {
            return;
        }
        MessageHeadersRelay relay = CxfBinding.getRelay(endpoint, exchange);
        CxfBinding.relayHeaders(Direction.OUT, (List)message.get((Object)Header.HEADER_LIST), requestContext, relay);
    }

    protected static void relayResponseHeaders(CxfEndpoint endpoint, CxfExchange exchange, Map<String, Object> context) {
        org.apache.cxf.message.Message message = exchange.getOutMessage();
        if (message == null) {
            return;
        }
        Map responseContext = (Map)context.get("ResponseContext");
        List headers = (List)responseContext.get(Header.HEADER_LIST);
        if (!endpoint.isRelayHeaders()) {
            responseContext.remove(Header.HEADER_LIST);
            Exchange e = exchange.getExchange();
            if (e == null) {
                return;
            }
            BindingOperationInfo bop = (BindingOperationInfo)e.get(BindingOperationInfo.class);
            if (null == bop) {
                return;
            }
            BindingMessageInfo bmi = bop.getOutput();
            List headersInfo = bmi.getExtensors(SoapHeaderInfo.class);
            if (headersInfo == null || headersInfo.size() == 0) {
                return;
            }
            MessageContentsList parameters = MessageContentsList.getContentsList((org.apache.cxf.message.Message)message);
            for (SoapHeaderInfo headerInfo : headersInfo) {
                Object o = parameters.get(headerInfo.getPart());
                if (o instanceof Holder) {
                    Holder holder = (Holder)o;
                    holder.value = null;
                    continue;
                }
                parameters.remove(headerInfo.getPart());
            }
            return;
        }
        if (headers == null || headers.size() == 0) {
            return;
        }
        MessageHeadersRelay relay = CxfBinding.getRelay(endpoint, exchange);
        CxfBinding.relayHeaders(Direction.IN, headers, responseContext, relay);
    }

    protected static MessageHeadersRelay getRelay(CxfEndpoint endpoint, CxfExchange exchange) {
        Binding b;
        MessageHeadersRelay relay = null;
        String ns = null;
        Endpoint e = null;
        Exchange cxfExchange = exchange.getExchange();
        if (cxfExchange != null) {
            e = (Endpoint)cxfExchange.get(Endpoint.class);
        }
        if (e != null && e.getBinding() != null && (b = e.getBinding()) != null && b.getBindingInfo() != null) {
            ns = b.getBindingInfo().getBindingId();
        }
        if (ns == null) {
            LOG.log(Level.WARNING, "No CXF Binding namespace can be resolved for relaying message headers,  using http://cxf.apache.org/bindings namespace");
        }
        if (ns != null) {
            relay = endpoint.getMessageHeadersRelay(ns);
        }
        if (relay == null) {
            LOG.log(Level.WARNING, "No MessageHeadersRelay instance is bound to '" + ns + "' namespace; using " + "http://cxf.apache.org/bindings" + " namespace");
            relay = endpoint.getMessageHeadersRelay("http://cxf.apache.org/bindings");
        }
        return relay;
    }

    protected static void relayHeaders(Direction direction, List<Header> from, Map<String, Object> context, MessageHeadersRelay relay) {
        ArrayList<Header> to = new ArrayList<Header>();
        relay.relay(direction, from, to);
        for (Header header : to) {
            header.setDirection(Header.Direction.DIRECTION_OUT);
        }
        if (to.size() > 0) {
            context.put(Header.HEADER_LIST, to);
        }
    }
}

