/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfSoapBinding {
    private static final Log LOG = LogFactory.getLog(CxfSoapBinding.class);

    private CxfSoapBinding() {
    }

    public static org.apache.cxf.message.Message getCxfInMessage(Exchange exchange, boolean isClient) {
        return CxfSoapBinding.getCxfInMessage((HeaderFilterStrategy)new DefaultHeaderFilterStrategy(), exchange, isClient);
    }

    public static org.apache.cxf.message.Message getCxfInMessage(HeaderFilterStrategy headerFilterStrategy, Exchange exchange, boolean isClient) {
        MessageImpl answer = new MessageImpl();
        org.apache.cxf.message.Exchange cxfExchange = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        Message message = null;
        message = isClient ? exchange.getOut() : exchange.getIn();
        ObjectHelper.notNull((Object)message, (String)"message");
        if (cxfExchange == null) {
            cxfExchange = new ExchangeImpl();
            exchange.setProperty("org.apache.cxf.message.exchange", (Object)cxfExchange);
        }
        CxfHeaderHelper.propagateCamelToCxf(headerFilterStrategy, message.getHeaders(), (org.apache.cxf.message.Message)answer);
        try {
            InputStream body = (InputStream)message.getBody(InputStream.class);
            answer.setContent(InputStream.class, (Object)body);
        }
        catch (NoTypeConversionAvailableException ex) {
            LOG.warn((Object)("Can't get right InputStream object here, the message body is " + message.getBody()));
            throw new RuntimeCamelException((Throwable)ex);
        }
        answer.putAll(message.getHeaders());
        answer.setExchange(cxfExchange);
        cxfExchange.setInMessage((org.apache.cxf.message.Message)answer);
        return answer;
    }

    public static org.apache.cxf.message.Message getCxfOutMessage(Exchange exchange, boolean isClient) {
        return CxfSoapBinding.getCxfOutMessage((HeaderFilterStrategy)new DefaultHeaderFilterStrategy(), exchange, isClient);
    }

    public static org.apache.cxf.message.Message getCxfOutMessage(HeaderFilterStrategy headerFilterStrategy, Exchange exchange, boolean isClient) {
        org.apache.cxf.message.Exchange cxfExchange = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        ObjectHelper.notNull((Object)cxfExchange, (String)"cxfExchange");
        Endpoint cxfEndpoint = (Endpoint)cxfExchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = cxfEndpoint.getBinding().createMessage();
        outMessage.setExchange(cxfExchange);
        cxfExchange.setOutMessage(outMessage);
        Message message = null;
        message = isClient ? exchange.getIn() : exchange.getOut();
        CxfHeaderHelper.propagateCamelToCxf(headerFilterStrategy, message.getHeaders(), outMessage);
        try {
            Source body = (Source)message.getBody(Source.class);
            outMessage.setContent(Source.class, (Object)body);
        }
        catch (NoTypeConversionAvailableException ex) {
            LOG.warn((Object)("Can't get right Source object here, the message body is " + message.getBody()));
        }
        outMessage.putAll(message.getHeaders());
        return outMessage;
    }

    public static void setProtocolHeader(Map<String, Object> headers, Map<String, List<String>> protocolHeader) {
        if (protocolHeader != null) {
            StringBuilder value = new StringBuilder(256);
            for (Map.Entry<String, List<String>> entry : protocolHeader.entrySet()) {
                value.setLength(0);
                boolean first = true;
                for (String s : entry.getValue()) {
                    if (!first) {
                        value.append("; ");
                    }
                    value.append(s);
                    first = false;
                }
                headers.put(entry.getKey(), value.toString());
            }
        }
    }
}

