/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.interceptors.AbstractMessageOutInterceptor;
import org.apache.camel.component.cxf.interceptors.DOMOutInterceptor;
import org.apache.camel.component.cxf.interceptors.SoapMessageInInterceptor;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageOutInterceptor
extends AbstractMessageOutInterceptor<SoapMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapMessageInInterceptor.class);

    public SoapMessageOutInterceptor() {
        super("prepare-send");
        this.addAfter(DOMOutInterceptor.class.getName());
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SoapBindingInfo soapBinding;
        String style;
        ArrayList<Element> payload = (ArrayList<Element>)message.get(List.class);
        Exchange exchange = message.getExchange();
        BindingMessageInfo bmi = (BindingMessageInfo)exchange.get(BindingMessageInfo.class);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("SoapMessageOutInterceptor binding operation style processing.");
        }
        if ("rpc".equals(style = (soapBinding = (SoapBindingInfo)exchange.get(BindingInfo.class)).getStyle(bmi.getBindingOperation().getOperationInfo()))) {
            OperationInfo oi = bmi.getBindingOperation().getOperationInfo();
            Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
            Definition def = (Definition)((ServiceInfo)ep.getService().getServiceInfos().get(0)).getProperty(WSDLServiceBuilder.WSDL_DEFINITION, Definition.class);
            String prefix = def.getPrefix(oi.getName().getNamespaceURI());
            if ("".equals(prefix)) {
                prefix = "tns";
            }
            QName opName = null;
            boolean isClient = this.isRequestor((Message)message);
            opName = isClient ? new QName(oi.getName().getNamespaceURI(), oi.getName().getLocalPart(), prefix) : new QName(oi.getName().getNamespaceURI(), oi.getName().getLocalPart() + "Response", prefix);
            Element opEl = this.createElement(opName, (List<Element>)payload);
            payload = new ArrayList<Element>();
            payload.add(opEl);
        }
        message.put(List.class, (Object)payload);
    }
}

