/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import org.apache.camel.component.cxf.invoker.CxfClient;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;

public class CxfClientFactoryBean
extends ClientFactoryBean {
    private boolean isJSR181Enabled;

    public void setJSR181Enabled(boolean enabled) {
        if (enabled) {
            this.setServiceFactory((ReflectionServiceFactoryBean)new JaxWsServiceFactoryBean());
        } else {
            this.setServiceFactory(new ReflectionServiceFactoryBean());
        }
        this.isJSR181Enabled = enabled;
    }

    public void setBindingId(String bind) {
        super.setBindingId(bind);
        if (this.isJSR181Enabled) {
            if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bind) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bind)) {
                this.setBindingConfig((BindingConfiguration)new JaxWsSoapBindingConfiguration((JaxWsServiceFactoryBean)this.getServiceFactory()));
            } else if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bind) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bind)) {
                this.setBindingConfig((BindingConfiguration)new JaxWsSoapBindingConfiguration((JaxWsServiceFactoryBean)this.getServiceFactory()));
                ((JaxWsSoapBindingConfiguration)this.getBindingConfig()).setMtomEnabled(true);
            }
        }
    }

    protected Client createClient(Endpoint ep) {
        return new CxfClient(this.getBus(), ep);
    }
}

