/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsProducer
extends DefaultProducer {
    JAXRSClientFactoryBean cfb;

    public CxfRsProducer(CxfRsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.cfb = endpoint.createJAXRSClientFactoryBean();
    }

    public void process(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("VarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        Client target = null;
        target = varValues == null ? this.cfb.create() : this.cfb.createWithValues(varValues);
        JAXRSServiceFactoryBean sfb = this.cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = (Object[])inMessage.getBody(Object[].class);
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        Object response = method.invoke((Object)target, parameters);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setBody(response);
        }
    }

    private Method findRightMethod(List<Class> resourceClasses, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method answer = null;
        for (Class clazz : resourceClasses) {
            try {
                answer = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            if (answer == null) continue;
            return answer;
        }
        throw new NoSuchMethodException("Can find the method " + methodName + "withe these parameter " + this.arrayToString(parameterTypes));
    }

    private Class[] getParameterTypes(Object[] objects) {
        Class[] answer = new Class[objects.length];
        int i = 0;
        for (Object obj : objects) {
            answer[i] = obj.getClass();
            ++i;
        }
        return answer;
    }

    private String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer("[");
        for (Object obj : array) {
            if (buffer.length() > 2) {
                buffer.append(",");
            }
            buffer.append(obj.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

