/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;

public class CxfProducer
extends DefaultProducer {
    private static final Log LOG = LogFactory.getLog(CxfProducer.class);
    private Client client;

    public CxfProducer(CxfEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.client = endpoint.createClient();
    }

    public void process(Exchange camelExchange) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process exchange: " + camelExchange));
        }
        ExchangeImpl cxfExchange = new ExchangeImpl();
        CxfEndpoint endpoint = (CxfEndpoint)this.getEndpoint();
        CxfBinding binding = endpoint.getCxfBinding();
        WrappedMessageContext requestContext = new WrappedMessageContext(new HashMap(), null, MessageContext.Scope.APPLICATION);
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        DataFormat dataFormat = endpoint.getDataFormat();
        camelExchange.setProperty("CamelCXFDataFormat", (Object)dataFormat);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Set Camel Exchange property: " + DataFormat.class.getName() + "=" + (Object)((Object)dataFormat)));
        }
        requestContext.put(DataFormat.class.getName(), (Object)dataFormat);
        if (dataFormat == DataFormat.MESSAGE) {
            cxfExchange.put((Object)"KeepConduitAlive", (Object)true);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Set CXF Exchange property: KeepConduitAlive=true");
            }
        }
        BindingOperationInfo boi = this.getBindingOperationInfo(camelExchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("BOI = " + boi));
        }
        ObjectHelper.notNull((Object)boi, (String)"You should set 'operationName' in header.");
        if (!endpoint.isWrapped() && boi != null && boi.isUnwrappedCapable()) {
            boi = boi.getUnwrappedOperation();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Unwrapped BOI " + boi));
            }
        }
        camelExchange.setProperty(BindingOperationInfo.class.getName(), (Object)boi);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Set exchange property: BindingOperationInfo: " + boi));
        }
        binding.populateCxfRequestFromExchange((org.apache.cxf.message.Exchange)cxfExchange, camelExchange, (Map<String, Object>)requestContext);
        requestContext.getScopes().remove(Message.PROTOCOL_HEADERS);
        HashMap<String, Map> invocationContext = new HashMap<String, Map>();
        invocationContext.put("ResponseContext", responseContext);
        invocationContext.put("RequestContext", requestContext.getWrappedMap());
        this.client.invoke(boi, this.getParams(endpoint, camelExchange), invocationContext, (org.apache.cxf.message.Exchange)cxfExchange);
        if (!boi.getOperationInfo().isOneWay()) {
            binding.populateExchangeFromCxfResponse(camelExchange, (org.apache.cxf.message.Exchange)cxfExchange, responseContext);
        }
    }

    private Object[] getParams(CxfEndpoint endpoint, Exchange exchange) {
        Object[] params = null;
        if (endpoint.getDataFormat() == DataFormat.POJO) {
            List list = (List)exchange.getIn().getBody(List.class);
            params = list != null ? list.toArray() : new Object[]{};
        } else if (endpoint.getDataFormat() == DataFormat.PAYLOAD) {
            params = new Object[]{exchange.getIn().getBody()};
        } else if (endpoint.getDataFormat() == DataFormat.MESSAGE) {
            params = new Object[]{exchange.getIn().getBody(InputStream.class)};
        }
        if (LOG.isTraceEnabled()) {
            if (params instanceof Object[]) {
                for (int i = 0; i < params.length; ++i) {
                    LOG.trace((Object)("params[" + i + "] = " + params[i]));
                }
            } else {
                LOG.trace((Object)("params = " + params));
            }
        }
        return params;
    }

    private BindingOperationInfo getBindingOperationInfo(Exchange ex) {
        BindingOperationInfo answer = null;
        String lp = (String)ex.getIn().getHeader("operationName", String.class);
        if (lp == null) {
            Collection bois;
            Iterator iter;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Try to find a default operation.  You should set 'operationName' in header.");
            }
            if ((iter = (bois = this.client.getEndpoint().getEndpointInfo().getBinding().getOperations()).iterator()).hasNext()) {
                answer = (BindingOperationInfo)iter.next();
            }
        } else {
            String ns = (String)ex.getIn().getHeader("operationNameSpace", String.class);
            if (ns == null) {
                ns = this.client.getEndpoint().getService().getName().getNamespaceURI();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Operation namespace not in header.  Set it to: " + ns));
                }
            }
            QName qname = new QName(ns, lp);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Operation qname = " + qname.toString()));
            }
            answer = this.client.getEndpoint().getEndpointInfo().getBinding().getOperation(qname);
        }
        return answer;
    }

    public Client getClient() {
        return this.client;
    }
}

