/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.cxfbean;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfSoapBinding;
import org.apache.camel.component.cxf.cxfbean.CxfBeanBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.helpers.CastUtils;

public class DefaultCxfBeanBinding
implements CxfBeanBinding {
    private static final Log LOG = LogFactory.getLog(DefaultCxfBeanBinding.class);

    public org.apache.cxf.message.Message createCxfMessageFromCamelExchange(Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy) {
        Message camelMessage = camelExchange.getIn();
        String requestContentType = this.getRequestContentType(camelMessage);
        String acceptContentTypes = (String)camelMessage.getHeader("Accept", String.class);
        if (acceptContentTypes == null) {
            acceptContentTypes = "*/*";
        }
        String enc = this.getCharacterEncoding(camelMessage);
        String path = this.getPath(camelMessage);
        String basePath = this.getBasePath(camelExchange);
        String verb = this.getVerb(camelMessage);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing " + camelExchange + ", requestContentType = " + requestContentType + ", acceptContentTypes = " + acceptContentTypes + ", encoding = " + enc + ", path = " + path + ", basePath = " + basePath + ", verb = " + verb));
        }
        org.apache.cxf.message.Message answer = CxfSoapBinding.getCxfInMessage(headerFilterStrategy, camelExchange, false);
        answer.put((Object)org.apache.cxf.message.Message.REQUEST_URI, (Object)path);
        answer.put((Object)org.apache.cxf.message.Message.BASE_PATH, (Object)basePath);
        answer.put((Object)org.apache.cxf.message.Message.HTTP_REQUEST_METHOD, (Object)verb);
        answer.put((Object)org.apache.cxf.message.Message.PATH_INFO, (Object)path);
        answer.put((Object)"Content-Type", (Object)requestContentType);
        answer.put((Object)"Accept", (Object)acceptContentTypes);
        answer.put((Object)org.apache.cxf.message.Message.ENCODING, (Object)enc);
        return answer;
    }

    public void propagateResponseHeadersToCamel(org.apache.cxf.message.Message cxfMessage, Exchange exchange, HeaderFilterStrategy strategy) {
        String key;
        Object value;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Propagating response headers from CXF message " + cxfMessage));
        }
        if (strategy == null) {
            return;
        }
        Map camelHeaders = exchange.getOut().getHeaders();
        Map cxfHeaders = CastUtils.cast((Map)((Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                camelHeaders.put(entry.getKey(), ((List)entry.getValue()).get(0));
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Populate header from CXF header=" + (String)entry.getKey() + " value=" + entry.getValue()));
            }
        }
        if ((value = cxfMessage.get((Object)(key = org.apache.cxf.message.Message.RESPONSE_CODE))) != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            camelHeaders.put("CamelHttpResponseCode", value);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Populate header from CXF header=" + key + " value=" + value + " as " + "CamelHttpResponseCode"));
            }
        }
    }

    protected String getPath(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpPath", String.class);
        return answer;
    }

    protected String getBasePath(Exchange camelExchange) {
        String answer = (String)camelExchange.getIn().getHeader("CamelCxfBeanRequestBasePath", String.class);
        if (answer == null) {
            answer = camelExchange.getFromEndpoint().getEndpointUri();
        }
        return answer;
    }

    protected String getVerb(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpMethod", String.class);
        return answer;
    }

    protected String getCharacterEncoding(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpCharacterEncoding", String.class);
        if (answer == null) {
            answer = (String)camelMessage.getHeader("CamelCharsetName", String.class);
        }
        return answer;
    }

    protected String getRequestContentType(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("Content-Type", String.class);
        if (answer != null) {
            return answer;
        }
        return "*/*";
    }
}

