/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsProducer
extends DefaultProducer {
    JAXRSClientFactoryBean cfb;

    public CxfRsProducer(CxfRsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.cfb = endpoint.createJAXRSClientFactoryBean();
    }

    public void process(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        Boolean httpClientAPI = (Boolean)inMessage.getHeader("CamelCxfRsUsingHttpAPI", Boolean.class);
        if (httpClientAPI != null && httpClientAPI.booleanValue()) {
            this.invokeHttpClient(exchange);
        } else {
            this.invokeProxyClient(exchange);
        }
    }

    protected void invokeHttpClient(Exchange exchange) {
        Message inMessage = exchange.getIn();
        WebClient client = this.cfb.createWebClient();
        String httpMethod = (String)inMessage.getHeader("CamelHttpMethod", String.class);
        Class responseClass = (Class)inMessage.getHeader("CamelCxfRsResponseClass", Class.class);
        String path = (String)inMessage.getHeader("CamelHttpPath", String.class);
        if (path != null) {
            client.path((Object)path);
        }
        Object body = null;
        if (!"GET".equals(httpMethod)) {
            body = this.checkRequestObject(inMessage.getBody());
        }
        Object response = null;
        response = responseClass == null ? client.invoke(httpMethod, body, InputStream.class) : (responseClass.equals(Response.class) ? client.invoke(httpMethod, body) : client.invoke(httpMethod, body, responseClass));
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setBody(response);
        }
    }

    protected void invokeProxyClient(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        Client target = null;
        target = varValues == null ? this.cfb.create() : this.cfb.createWithValues(varValues);
        JAXRSServiceFactoryBean sfb = this.cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = (Object[])inMessage.getBody(Object[].class);
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        Object response = method.invoke((Object)target, parameters);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setBody(response);
        }
    }

    private Method findRightMethod(List<Class> resourceClasses, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method answer = null;
        for (Class clazz : resourceClasses) {
            try {
                answer = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            if (answer == null) continue;
            return answer;
        }
        throw new NoSuchMethodException("Can find the method " + methodName + "withe these parameter " + this.arrayToString(parameterTypes));
    }

    private Object checkRequestObject(Object request) {
        if (request != null) {
            if (request instanceof MessageContentsList) {
                request = ((MessageContentsList)request).get(0);
            } else if (request instanceof List) {
                request = ((List)request).get(0);
            } else if (request.getClass().isArray()) {
                request = ((Object[])request)[0];
            }
        }
        return request;
    }

    private Class[] getParameterTypes(Object[] objects) {
        Class[] answer = new Class[objects.length];
        int i = 0;
        for (Object obj : objects) {
            answer[i] = obj.getClass();
            ++i;
        }
        return answer;
    }

    private String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer("[");
        for (Object obj : array) {
            if (buffer.length() > 2) {
                buffer.append(",");
            }
            buffer.append(obj.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

