/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfSpringEndpoint
extends CxfEndpoint {
    private CxfEndpointBean bean;
    private String beanId;
    private ConfigurerImpl configurer;
    private String serviceNamespace;
    private String serviceLocalName;
    private String endpointLocalName;
    private String endpointNamespace;

    public CxfSpringEndpoint(CamelContext context, CxfEndpointBean bean) throws Exception {
        super(bean.getAddress(), context);
        this.init(bean);
    }

    public CxfSpringEndpoint(CxfComponent component, CxfEndpointBean bean) throws Exception {
        super(bean.getAddress(), component);
        this.init(bean);
    }

    private void init(CxfEndpointBean bean) throws Exception {
        this.bean = bean;
        this.configurer = new ConfigurerImpl(((SpringCamelContext)this.getCamelContext()).getApplicationContext());
    }

    private Class<?> getSEIClass() throws ClassNotFoundException {
        Class answer = null;
        answer = this.getServiceClass() != null ? ClassLoaderUtils.loadClass((String)this.getServiceClass(), ((Object)((Object)this)).getClass()) : this.bean.getServiceClass();
        return answer;
    }

    @Override
    protected Bus doGetBus() {
        return this.bean.getBus();
    }

    public CxfEndpointBean getBean() {
        return this.bean;
    }

    @Override
    Client createClient() throws Exception {
        Class<?> cls = this.getSEIClass();
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(cls, (String)"serviceClass");
        }
        ClientProxyFactoryBean factoryBean = this.createClientFactoryBean(cls);
        this.configure(factoryBean);
        this.setupClientFactoryBean(factoryBean, cls);
        QName serviceQName = null;
        try {
            serviceQName = factoryBean.getServiceName();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (serviceQName == null && this.getServiceLocalName() != null) {
            factoryBean.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (factoryBean.getEndpointName() == null && this.getEndpointLocalName() != null) {
            factoryBean.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        if (cls == null) {
            return (Client)factoryBean.create();
        }
        return ((ClientProxy)Proxy.getInvocationHandler(factoryBean.create())).getClient();
    }

    @Override
    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<?> cls = this.getSEIClass();
        Object answer = null;
        if (cls == null) {
            if (!this.getDataFormat().equals((Object)DataFormat.POJO)) {
                answer = new ServerFactoryBean((ReflectionServiceFactoryBean)new WSDLServiceFactoryBean());
            } else {
                ObjectHelper.notNull(cls, (String)"serviceClass");
            }
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.configure(answer);
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        if (answer.getServiceName() == null && this.getServiceLocalName() != null) {
            answer.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (answer.getEndpointName() == null && this.getEndpointLocalName() != null) {
            answer.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        return answer;
    }

    void configure(Object beanInstance) {
        ConfigurableApplicationContext context;
        if (((SpringCamelContext)this.getCamelContext()).getApplicationContext() instanceof ConfigurableApplicationContext && !(context = (ConfigurableApplicationContext)((SpringCamelContext)this.getCamelContext()).getApplicationContext()).isActive()) {
            context.refresh();
        }
        this.configurer.configureBean(this.beanId, beanInstance);
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String id) {
        this.beanId = id;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public void setServiceLocalName(String serviceLocalName) {
        this.serviceLocalName = serviceLocalName;
    }

    public String getServiceLocalName() {
        return this.serviceLocalName;
    }

    public String getEndpointLocalName() {
        return this.endpointLocalName;
    }

    public void setEndpointLocalName(String endpointLocalName) {
        this.endpointLocalName = endpointLocalName;
    }

    public void setEndpointNamespace(String endpointNamespace) {
        this.endpointNamespace = endpointNamespace;
    }

    public String getEndpointNamespace() {
        return this.endpointNamespace;
    }
}

