/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.cxf.CxfSoapBinding;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public class CamelDestination
extends AbstractDestination
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-destination";
    private static final Logger LOG = LogUtils.getL7dLogger(CamelDestination.class);
    final ConduitInitiator conduitInitiator;
    CamelContext camelContext;
    Consumer consumer;
    String camelDestinationUri;
    private ProducerTemplate camelTemplate;
    private Endpoint distinationEndpoint;
    private HeaderFilterStrategy headerFilterStrategy;

    public CamelDestination(CamelContext camelContext, Bus bus, ConduitInitiator ci, EndpointInfo info) throws IOException {
        this(camelContext, bus, ci, info, null);
    }

    public CamelDestination(CamelContext camelContext, Bus bus, ConduitInitiator ci, EndpointInfo info, HeaderFilterStrategy headerFilterStrategy) throws IOException {
        super(bus, CamelDestination.getTargetReference((EndpointInfo)info, (Bus)bus), info);
        this.camelContext = camelContext;
        this.conduitInitiator = ci;
        this.camelDestinationUri = this.endpointInfo.getAddress().substring("camel:".length());
        if (this.camelDestinationUri.startsWith("//")) {
            this.camelDestinationUri = this.camelDestinationUri.substring(2);
        }
        this.initConfig();
        this.headerFilterStrategy = headerFilterStrategy;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(inMessage);
    }

    public void activate() {
        this.getLogger().log(Level.FINE, "CamelDestination activate().... ");
        try {
            this.getLogger().log(Level.FINE, "establishing Camel connection");
            this.distinationEndpoint = this.camelContext.getEndpoint(this.camelDestinationUri);
            this.consumer = this.distinationEndpoint.createConsumer((Processor)new ConsumerProcessor());
            this.consumer.start();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Camel connect failed with Exception : ", ex);
        }
    }

    public void deactivate() {
        try {
            this.consumer.stop();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Camel stop failed with Exception : ", e);
        }
    }

    public void shutdown() {
        this.getLogger().log(Level.FINE, "CamelDestination shutdown()");
        this.deactivate();
    }

    public ProducerTemplate getCamelTemplate() {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.getCamelContext().createProducerTemplate();
        }
        return this.camelTemplate;
    }

    public void setCamelTemplate(ProducerTemplate template) {
        this.camelTemplate = template;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public CamelContext getCamelContext() {
        if (this.camelContext == null) {
            this.getLogger().log(Level.INFO, "No CamelContext injected, create a default one");
            this.camelContext = new DefaultCamelContext();
        }
        return this.camelContext;
    }

    protected void incoming(Exchange camelExchange) {
        this.getLogger().log(Level.FINE, "server received request: ", camelExchange);
        Message inMessage = CxfSoapBinding.getCxfInMessage(this.headerFilterStrategy, camelExchange, false);
        inMessage.put((Object)"org.apache.camel.exchange", (Object)camelExchange);
        ((MessageImpl)inMessage).setDestination((Destination)this);
        this.incomingObserver.onMessage(inMessage);
    }

    public String getBeanName() {
        if (this.endpointInfo == null || this.endpointInfo.getName() == null) {
            return "default.camel-destination";
        }
        return this.endpointInfo.getName().toString() + BASE_BEAN_NAME_SUFFIX;
    }

    public String getCamelDestinationUri() {
        return this.camelDestinationUri;
    }

    private void initConfig() {
        Configurer configurer;
        if (this.bus != null && null != (configurer = (Configurer)this.bus.getExtension(Configurer.class))) {
            configurer.configureBean((Object)this);
        }
    }

    protected boolean markPartialResponse(Message partialResponse, EndpointReferenceType decoupledTarget) {
        return true;
    }

    protected ConduitInitiator getConduitInitiator() {
        return this.conduitInitiator;
    }

    protected void propagateResponseHeadersToCamel(Message outMessage, Exchange camelExchange) {
        CxfHeaderHelper.propagateCxfToCamel(this.headerFilterStrategy, outMessage, camelExchange.getOut().getHeaders(), camelExchange);
    }

    private class CamelOutputStream
    extends CachedOutputStream {
        private Message outMessage;

        public CamelOutputStream(Message m) {
            this.outMessage = m;
        }

        private void commitOutputMessage() throws IOException {
            Exchange camelExchange = (Exchange)this.outMessage.get((Object)"org.apache.camel.exchange");
            CamelDestination.this.propagateResponseHeadersToCamel(this.outMessage, camelExchange);
            CachedOutputStream outputStream = (CachedOutputStream)this.outMessage.getContent(OutputStream.class);
            camelExchange.getOut().setBody((Object)outputStream.getBytes());
            CamelDestination.this.getLogger().log(Level.FINE, "send the response message: " + outputStream);
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        Exchange camelExchange;
        org.apache.cxf.message.Exchange cxfExchange;

        BackChannelConduit(Message message) {
            super(EndpointReferenceUtils.getAnonymousEndpointReference());
            this.inMessage = message;
            this.cxfExchange = this.inMessage.getExchange();
            this.camelExchange = (Exchange)this.cxfExchange.get(Exchange.class);
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)"org.apache.camel.exchange", this.inMessage.get((Object)"org.apache.camel.exchange"));
            message.setContent(OutputStream.class, (Object)new CamelOutputStream(message));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }

    protected class ConsumerProcessor
    implements Processor {
        protected ConsumerProcessor() {
        }

        public void process(Exchange exchange) {
            try {
                CamelDestination.this.incoming(exchange);
            }
            catch (Throwable ex) {
                CamelDestination.this.getLogger().log(Level.WARNING, "Failed to process incoming message : ", ex);
            }
        }
    }
}

